/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.common.util.QuoteUtils;
import com.huawei.hwclouds.migration.oracle.model.SqlLiteral;
import com.huawei.hwclouds.migration.oracle.model.SqlTypeName;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import java.math.BigDecimal;

public class DefaultValueVisitor
extends AbstractVisitor<SqlLiteral> {
    private SqlLiteral defaultValue = null;

    public DefaultValueVisitor() {
        this((SqlLiteral)null);
    }

    public DefaultValueVisitor(SqlLiteral defaultValue) {
        this.defaultValue = defaultValue == null ? new SqlLiteral(null, null) : defaultValue;
    }

    @Override
    protected SqlLiteral defaultResult() {
        return null;
    }

    @Override
    public SqlLiteral visitDefaultValue(OracleParser.DefaultValueContext ctx) {
        if (ctx.expression() != null) {
            String expression = ctx.expression().getText();
            this.defaultValue.setType(SqlTypeName.ANY);
            this.defaultValue.setValue(expression);
            this.defaultValue.setExpression(true);
            return this.defaultValue;
        }
        if (ctx.constant() != null) {
            this.setAttributes(ctx);
        }
        return this.defaultValue;
    }

    private SqlLiteral setAttributes(OracleParser.DefaultValueContext ctx) {
        if (ctx.constant() instanceof OracleParser.QuoteConstantContext) {
            OracleParser.QuoteConstantContext quoteConstant = (OracleParser.QuoteConstantContext)ctx.constant();
            this.defaultValue.setType(SqlTypeName.VARCHAR);
            this.defaultValue.setValue(QuoteUtils.removeSingleQuote(quoteConstant.getText()));
        }
        if (ctx.constant() instanceof OracleParser.NumericConstantContext) {
            OracleParser.NumericConstantContext numericConstant = (OracleParser.NumericConstantContext)ctx.constant();
            this.defaultValue.setType(SqlTypeName.DECIMAL);
            String number = ctx.unaryOperator() != null ? ctx.unaryOperator().getText() + numericConstant.getText() : numericConstant.getText();
            this.defaultValue.setValue(new BigDecimal(number));
        }
        if (ctx.constant() instanceof OracleParser.OtherConstantContext) {
            OracleParser.OtherConstantContext otherConstant = (OracleParser.OtherConstantContext)ctx.constant();
            if (otherConstant.NULL_() != null) {
                this.defaultValue.setType(SqlTypeName.UNKOWN);
                this.defaultValue.setValue(null);
            }
            if (otherConstant.TRUE() != null || otherConstant.FALSE() != null) {
                this.defaultValue.setType(SqlTypeName.BOOLEAN);
                this.defaultValue.setValue(otherConstant.getText());
            }
        }
        return this.defaultValue;
    }
}

