/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.common.util.ParserRuntimeException;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.LogicalExpression;
import com.huawei.hwclouds.migration.oracle.model.LogicalOperation;
import com.huawei.hwclouds.migration.oracle.model.MultisetExpression;
import com.huawei.hwclouds.migration.oracle.model.SubQuery;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.LogicalOperationVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.MultisetExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SubQueryVisitor;
import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;

public class ExpressionVisitor
extends AbstractVisitor<Expression> {
    private Expression expression = new Expression();

    @Override
    protected Expression defaultResult() {
        return this.expression;
    }

    @Override
    public Expression visitExpression(OracleParser.ExpressionContext ctx) {
        if (ctx.cursorExpression() != null) {
            throw new ParserRuntimeException("visit cursorExpression not support");
        }
        if (ctx.logicalExpression() != null) {
            this.expression = (Expression)new ExpressionVisitor().visit((ParseTree)ctx.logicalExpression());
        }
        return this.defaultResult();
    }

    @Override
    public Expression visitCursorExpression(OracleParser.CursorExpressionContext ctx) {
        this.expression.setCursorExpression((SubQuery)new SubQueryVisitor().visit((ParseTree)ctx.subQuery()));
        return this.defaultResult();
    }

    @Override
    public Expression visitBinaryLogicalExpression(OracleParser.BinaryLogicalExpressionContext ctx) {
        LogicalExpression logicalExpression = new LogicalExpression();
        logicalExpression.setFLogicalExpression(((Expression)new ExpressionVisitor().visit((ParseTree)ctx.logicalExpression(0))).getLogicalExpression());
        logicalExpression.setOperator(ctx.AND() != null ? ctx.AND().getText() : ctx.OR().getText());
        logicalExpression.setSLogicalExpression(((Expression)new ExpressionVisitor().visit((ParseTree)ctx.logicalExpression(1))).getLogicalExpression());
        this.expression.setLogicalExpression(logicalExpression);
        return this.defaultResult();
    }

    @Override
    public Expression visitUnaryLogicalExpression(OracleParser.UnaryLogicalExpressionContext ctx) {
        LogicalExpression logicalExpression = new LogicalExpression();
        logicalExpression.setExistNot(ctx.NOT() != null);
        logicalExpression.setMultisetExpression((MultisetExpression)new MultisetExpressionVisitor().visit((ParseTree)ctx.multisetExpression()));
        ArrayList<LogicalOperation> logicalOperationList = new ArrayList<LogicalOperation>();
        for (int i = 0; i < ctx.logicalOperation().size(); ++i) {
            LogicalOperation logicalOperation = (LogicalOperation)new LogicalOperationVisitor().visit((ParseTree)ctx.logicalOperation(i));
            logicalOperationList.add(logicalOperation);
        }
        logicalExpression.setLogicalOperationList(logicalOperationList);
        this.expression.setLogicalExpression(logicalExpression);
        return this.defaultResult();
    }
}

