/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.HavingClause;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.JsonCondition;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class HavingClauseVisitor
extends AbstractVisitor<HavingClause> {
    private HavingClause havingClause = new HavingClause();

    @Override
    protected HavingClause defaultResult() {
        return this.havingClause;
    }

    @Override
    public HavingClause visitExpression(OracleParser.ExpressionContext ctx) {
        this.havingClause.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)ctx));
        return this.defaultResult();
    }

    @Override
    public HavingClause visitJsonCondition(OracleParser.JsonConditionContext ctx) {
        JsonCondition jsonCondition = new JsonCondition();
        if (ctx.columnName() != null) {
            jsonCondition.setColumnName(new Identifier(ctx.columnName().getText()));
            jsonCondition.setHasNot(ctx.NOT() != null);
            jsonCondition.setFormatJson(ctx.FORMAT() != null);
            if (ctx.WITHOUT() != null) {
                jsonCondition.setUniqueKeys("WITHOUT UNIQUE KEYS");
            } else {
                jsonCondition.setUniqueKeys("WITH UNIQUE KEYS");
            }
            if (ctx.STRICT() != null) {
                jsonCondition.setStrictOrLax("STRICT");
            }
            if (ctx.LAX() != null) {
                jsonCondition.setStrictOrLax("LAX");
            }
        }
        if (ctx.expressions() != null) {
            List<OracleParser.ExpressionContext> expression = ctx.expressions().expression();
            for (int i = 0; i < expression.size(); ++i) {
                jsonCondition.addJsonEqualExpression((Expression)new ExpressionVisitor().visit((ParseTree)expression.get(i)));
            }
        }
        this.havingClause.setJsonCondition(jsonCondition);
        return this.defaultResult();
    }
}

