/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.ExpressionAlias;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.ModelColumnClauses;
import com.huawei.hwclouds.migration.oracle.model.QueryBlock;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.QueryBlockVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class ModelColumnClausesVisitor
extends AbstractVisitor<ModelColumnClauses> {
    private ModelColumnClauses modelColumnClauses = new ModelColumnClauses();

    @Override
    protected ModelColumnClauses defaultResult() {
        return this.modelColumnClauses;
    }

    @Override
    public ModelColumnClauses visitModelColumnPartitionPart(OracleParser.ModelColumnPartitionPartContext ctx) {
        this.modelColumnClauses.setPartitionByInfos(this.getSqlExpressionAlias(ctx.modelColumnList().modelColumn()));
        return this.defaultResult();
    }

    @Override
    public ModelColumnClauses visitModelColumnDimensionBy(OracleParser.ModelColumnDimensionByContext ctx) {
        this.modelColumnClauses.setDimensionByInfos(this.getSqlExpressionAlias(ctx.modelColumnList().modelColumn()));
        return this.defaultResult();
    }

    @Override
    public ModelColumnClauses visitModelColumnMeasures(OracleParser.ModelColumnMeasuresContext ctx) {
        this.modelColumnClauses.setMeasuresInfos(this.getSqlExpressionAlias(ctx.modelColumnList().modelColumn()));
        return this.defaultResult();
    }

    private SqlNodeList<ExpressionAlias> getSqlExpressionAlias(List<OracleParser.ModelColumnContext> modelColumns) {
        SqlNodeList<ExpressionAlias> expressionAliasList = new SqlNodeList<ExpressionAlias>();
        for (int i = 0; i < modelColumns.size(); ++i) {
            ExpressionAlias expressionAlias = new ExpressionAlias();
            if (modelColumns.get(i).expression() != null) {
                Expression expression = (Expression)new ExpressionVisitor().visit((ParseTree)modelColumns.get(i).expression());
                expressionAlias.setExpression(expression);
            }
            if (modelColumns.get(i).queryBlock() != null) {
                QueryBlock queryBlock = (QueryBlock)new QueryBlockVisitor().visit((ParseTree)modelColumns.get(i).queryBlock());
                expressionAlias.setQueryBlock(queryBlock);
            }
            if (modelColumns.get(i).columnAlias() != null) {
                String alias = modelColumns.get(i).columnAlias().getText();
                expressionAlias.setAlias(new Identifier(alias));
            }
            expressionAliasList.addNode(expressionAlias);
        }
        return expressionAliasList;
    }
}

