/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.FetchClause;
import com.huawei.hwclouds.migration.oracle.model.FromClause;
import com.huawei.hwclouds.migration.oracle.model.GroupByClause;
import com.huawei.hwclouds.migration.oracle.model.HierarchicalQuery;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.IntoClause;
import com.huawei.hwclouds.migration.oracle.model.ModelClause;
import com.huawei.hwclouds.migration.oracle.model.OffsetClause;
import com.huawei.hwclouds.migration.oracle.model.OrderByClause;
import com.huawei.hwclouds.migration.oracle.model.QueryBlock;
import com.huawei.hwclouds.migration.oracle.model.SelectListElement;
import com.huawei.hwclouds.migration.oracle.model.WhereClause;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.FromClauseVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.GroupByClauseVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.HierarchicalQueryClauseVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.IntoClauseVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ModelClauseVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.OrderByClauseVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SelectListElementVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.WhereClauseVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class QueryBlockVisitor
extends AbstractVisitor<QueryBlock> {
    private QueryBlock queryBlock = new QueryBlock();

    @Override
    protected QueryBlock defaultResult() {
        return this.queryBlock;
    }

    @Override
    public QueryBlock visitQueryBlock(OracleParser.QueryBlockContext ctx) {
        String queryType = this.getQueryType(ctx);
        if (queryType != null) {
            this.queryBlock.setQueryType(new Identifier(queryType));
        }
        this.visitSelectedList(ctx.selectedList());
        this.setQueryBlockAttribute(ctx);
        if (ctx.offsetClause() != null) {
            OffsetClause offsetClause = new OffsetClause();
            OracleParser.OffsetClauseContext offsetClauseContext = ctx.offsetClause();
            offsetClause.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)offsetClauseContext.expression()));
            if (offsetClauseContext.ROW() != null) {
                offsetClause.setRow(new Identifier("ROW"));
            } else {
                offsetClause.setRow(new Identifier("ROWS"));
            }
            this.queryBlock.setOffsetClause(offsetClause);
        }
        if (ctx.fetchClause() != null) {
            FetchClause fetchClause = this.getSqlFetchClause(ctx.fetchClause());
            this.queryBlock.setFetchClause(fetchClause);
        }
        return this.defaultResult();
    }

    @Override
    public QueryBlock visitSelectedList(OracleParser.SelectedListContext ctx) {
        List<OracleParser.SelectListElementsContext> contexts = ctx.selectListElements();
        if (contexts != null && contexts.size() > 0) {
            for (int i = 0; i < contexts.size(); ++i) {
                SelectListElement listElement = (SelectListElement)new SelectListElementVisitor().visit((ParseTree)contexts.get(i));
                this.queryBlock.addSelectListElements(listElement);
            }
        } else {
            this.queryBlock.setStar(true);
        }
        return this.defaultResult();
    }

    private FetchClause getSqlFetchClause(OracleParser.FetchClauseContext fetchClauseContext) {
        FetchClause fetchClause = new FetchClause();
        if (fetchClauseContext.ROW() != null) {
            fetchClause.setRow(new Identifier("ROW"));
        } else {
            fetchClause.setRow(new Identifier("ROWS"));
        }
        if (fetchClauseContext.ONLY() != null) {
            fetchClause.setRow(new Identifier("ONLY"));
        } else {
            fetchClause.setRow(new Identifier("WITH TIES"));
        }
        fetchClause.setPercentKeyword(fetchClauseContext.PERCENT_KEYWORD() != null);
        fetchClause.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)fetchClauseContext.expression()));
        return fetchClause;
    }

    private void setQueryBlockAttribute(OracleParser.QueryBlockContext ctx) {
        if (ctx.intoClause() != null) {
            this.queryBlock.setIntoClause((IntoClause)new IntoClauseVisitor().visit((ParseTree)ctx.intoClause()));
        }
        if (ctx.fromClause() != null) {
            this.queryBlock.setFromClause((FromClause)new FromClauseVisitor().visit((ParseTree)ctx.fromClause()));
        }
        if (ctx.whereClause() != null) {
            this.queryBlock.setWhereClause((WhereClause)new WhereClauseVisitor().visit((ParseTree)ctx.whereClause()));
        }
        if (ctx.hierarchicalQueryClause() != null) {
            this.queryBlock.setHierarchicalQuery((HierarchicalQuery)new HierarchicalQueryClauseVisitor().visit((ParseTree)ctx.hierarchicalQueryClause()));
        }
        if (ctx.groupByClause() != null) {
            this.queryBlock.setGroupByClause((GroupByClause)new GroupByClauseVisitor().visit((ParseTree)ctx.groupByClause()));
        }
        if (ctx.modelClause() != null) {
            this.queryBlock.setModelClause((ModelClause)new ModelClauseVisitor().visit((ParseTree)ctx.modelClause()));
        }
        if (ctx.orderByClause() != null) {
            this.queryBlock.setOrderByClause((OrderByClause)new OrderByClauseVisitor().visit((ParseTree)ctx.orderByClause()));
        }
    }

    private String getQueryType(OracleParser.QueryBlockContext ctx) {
        String queryType = null;
        if (ctx.DISTINCT() != null) {
            queryType = "DISTINCT";
        }
        if (ctx.UNIQUE() != null) {
            queryType = "UNIQUE";
        }
        if (ctx.ALL() != null) {
            queryType = "ALL";
        }
        return queryType;
    }
}

