/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.AlterSession;
import com.huawei.hwclouds.migration.oracle.model.AlterSessionSetClause;
import com.huawei.hwclouds.migration.oracle.model.RoleStruct;
import com.huawei.hwclouds.migration.oracle.model.SessionControlStatement;
import com.huawei.hwclouds.migration.oracle.nodes.SqlCommentNode;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;

public class SessionControlStatementVisitor
extends AbstractVisitor<SqlCommentNode> {
    private SessionControlStatement sessionControlStatement = new SessionControlStatement();

    @Override
    protected SqlCommentNode defaultResult() {
        return this.sessionControlStatement;
    }

    @Override
    public SqlCommentNode visitAlterSession(OracleParser.AlterSessionContext ctx) {
        AlterSession alterSession = new AlterSession();
        if (ctx.ADVISE() != null) {
            alterSession.setKeyWord("ADVISE");
            if (ctx.COMMIT() != null) {
                alterSession.setTransactionsKeyWord("COMMIT");
            } else if (ctx.ROLLBACK() != null) {
                alterSession.setTransactionsKeyWord("ROLLBACK");
            } else {
                alterSession.setTransactionsKeyWord("NOTHING");
            }
        } else if (ctx.CLOSE() != null) {
            alterSession.setKeyWord("CLOSE");
            alterSession.setParameterNameOrLiteral(ctx.parameterName().getText());
        } else if (ctx.PROCEDURE() != null) {
            alterSession.setKeyWord("PROCEDURE");
            alterSession.setEnableOrDisable(ctx.enableOrDisable().getText());
        } else if (ctx.GUARD() != null) {
            alterSession.setKeyWord("GUARD");
            alterSession.setEnableOrDisable(ctx.enableOrDisable().getText());
        } else if (ctx.PARALLEL().size() > 0) {
            alterSession.setKeyWord("PARALLEL");
            if (ctx.FORCE() != null) {
                alterSession.setEnableOrDisable("FORCE");
            } else {
                alterSession.setEnableOrDisable(ctx.enableOrDisable().getText());
            }
            if (ctx.DML() != null) {
                alterSession.setSqlType("DML");
            } else if (ctx.DDL() != null) {
                alterSession.setSqlType("DDL");
            } else {
                alterSession.setSqlType("QUERY");
            }
            if (ctx.literal() != null) {
                alterSession.setParameterNameOrLiteral(ctx.literal().getText());
            } else if (ctx.parameterName() != null) {
                alterSession.setParameterNameOrLiteral(ctx.parameterName().getText());
            }
        } else {
            alterSession.setKeyWord("SET");
            OracleParser.AlterSessionSetClauseContext alterSessionSetClauseContext = ctx.alterSessionSetClause();
            AlterSessionSetClause alterSessionSetClause = new AlterSessionSetClause();
            alterSessionSetClause.setParameterName(alterSessionSetClauseContext.parameterName().getText());
            alterSessionSetClause.setParameterValue(alterSessionSetClauseContext.parameterValue().getText());
            alterSession.setAlterSessionSetClause(alterSessionSetClause);
        }
        this.sessionControlStatement.setAlterSession(alterSession);
        return this.defaultResult();
    }

    @Override
    public SqlCommentNode visitAlterRole(OracleParser.AlterRoleContext ctx) {
        RoleStruct roleStruct = new RoleStruct();
        roleStruct.setRoleType("ALTER ROLE");
        roleStruct.setRoleName(ctx.roleName().getText());
        OracleParser.RoleIdentifiedClauseContext roleIdentifiedClauseContext = ctx.roleIdentifiedClause();
        this.getRoleIdentifiedClause(roleStruct, roleIdentifiedClauseContext);
        if (ctx.containerClause() != null) {
            if (ctx.containerClause().CURRENT() != null) {
                roleStruct.setContainerClause("CONTAINER = CURRENT");
            } else {
                roleStruct.setContainerClause("CONTAINER = ALL");
            }
        }
        this.sessionControlStatement.setRoleStruct(roleStruct);
        return this.defaultResult();
    }

    @Override
    public SqlCommentNode visitCreateRole(OracleParser.CreateRoleContext ctx) {
        RoleStruct roleStruct = new RoleStruct();
        roleStruct.setRoleType("CREATE ROLE");
        roleStruct.setRoleName(ctx.roleName().getText());
        if (ctx.roleIdentifiedClause() != null) {
            OracleParser.RoleIdentifiedClauseContext roleIdentifiedClauseContext = ctx.roleIdentifiedClause();
            this.getRoleIdentifiedClause(roleStruct, roleIdentifiedClauseContext);
        }
        if (ctx.containerClause() != null) {
            if (ctx.containerClause().CURRENT() != null) {
                roleStruct.setContainerClause("CONTAINER = CURRENT");
            } else {
                roleStruct.setContainerClause("CONTAINER = ALL");
            }
        }
        this.sessionControlStatement.setRoleStruct(roleStruct);
        return this.defaultResult();
    }

    @Override
    public SqlCommentNode visitDropRole(OracleParser.DropRoleContext ctx) {
        RoleStruct roleStruct = new RoleStruct();
        roleStruct.setRoleType("DROP ROLE");
        roleStruct.setRoleName(ctx.roleName().getText());
        this.sessionControlStatement.setRoleStruct(roleStruct);
        return this.defaultResult();
    }

    private void getRoleIdentifiedClause(RoleStruct roleStruct, OracleParser.RoleIdentifiedClauseContext roleIdentifiedClauseContext) {
        if (roleIdentifiedClauseContext.NOT() != null) {
            roleStruct.setRoleIdentifiedClause("NOT IDENTIFIED");
        } else if (roleIdentifiedClauseContext.BY() != null) {
            roleStruct.setRoleIdentifiedClause("IDENTIFIED BY " + roleIdentifiedClauseContext.identifier().getText());
        } else if (roleIdentifiedClauseContext.USING() != null) {
            if (roleIdentifiedClauseContext.idExpression() != null) {
                roleStruct.setRoleIdentifiedClause("USING " + roleIdentifiedClauseContext.identifier().getText() + "." + roleIdentifiedClauseContext.idExpression().getText());
            } else {
                roleStruct.setRoleIdentifiedClause("USING " + roleIdentifiedClauseContext.identifier().getText());
            }
        } else if (roleIdentifiedClauseContext.EXTERNALLY() != null) {
            roleStruct.setRoleIdentifiedClause("EXTERNALLY");
        } else {
            roleStruct.setRoleIdentifiedClause("GLOBALLY");
        }
    }
}

