/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.IndexAttributes;
import com.huawei.hwclouds.migration.oracle.model.IndexOptions;
import com.huawei.hwclouds.migration.oracle.model.IndexPartition;
import com.huawei.hwclouds.migration.oracle.model.PartitionedTable;
import com.huawei.hwclouds.migration.oracle.model.PhysicalAttributesClause;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.PhysicalAttributesClauseVisitor;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class SqlIndexOptionsVisitor
extends AbstractVisitor<IndexOptions> {
    private IndexOptions indexOptions = new IndexOptions();

    @Override
    protected IndexOptions defaultResult() {
        return this.indexOptions;
    }

    @Override
    public IndexOptions visitLocalPartitionedIndex(OracleParser.LocalPartitionedIndexContext ctx) {
        List<OracleParser.PartitionedTableContext> partitionedTableContexts;
        IndexPartition indexPartition = new IndexPartition();
        if (ctx.onRangePartitionedTable() != null) {
            partitionedTableContexts = ctx.onRangePartitionedTable().partitionedTable();
            this.dealWithPartitionedTable(partitionedTableContexts, indexPartition);
        }
        if (ctx.onListPartitionedTable() != null) {
            partitionedTableContexts = ctx.onListPartitionedTable().partitionedTable();
            this.dealWithPartitionedTable(partitionedTableContexts, indexPartition);
        }
        this.indexOptions.setLocalPartition(indexPartition);
        return this.defaultResult();
    }

    @Override
    public IndexOptions visitIndexAttributes(OracleParser.IndexAttributesContext ctx) {
        IndexAttributes indexAttributes = new IndexAttributes();
        if (ctx.physicalAttributesClause() != null) {
            PhysicalAttributesClause physicalAttributesClause = (PhysicalAttributesClause)new PhysicalAttributesClauseVisitor().visit((ParseTree)ctx.physicalAttributesClause());
            indexAttributes.setIndexAttributeValue(physicalAttributesClause.getPhyClause());
        } else {
            String value = "";
            for (int i = 0; i < ctx.getChildCount(); ++i) {
                if (ctx.getChild(i).getChildCount() > 0) {
                    for (int j = 0; j < ctx.getChild(i).getChildCount(); ++j) {
                        value = value + ctx.getChild(i).getChild(j).getText() + " ";
                    }
                    continue;
                }
                value = value + ctx.getChild(i).getText() + " ";
            }
            indexAttributes.setIndexAttributeValue(value);
        }
        this.indexOptions.setIndexAttributes(indexAttributes);
        return this.defaultResult();
    }

    private void dealWithPartitionedTable(List<OracleParser.PartitionedTableContext> partitionedTableContexts, IndexPartition indexPartition) {
        ArrayList<PartitionedTable> partitionedTables = new ArrayList<PartitionedTable>();
        for (int i = 0; i < partitionedTableContexts.size(); ++i) {
            PartitionedTable partitionedTable = new PartitionedTable();
            OracleParser.PartitionedTableContext partitionedTableContext = partitionedTableContexts.get(i);
            if (partitionedTableContext.partitionName() != null) {
                partitionedTable.setPartition(partitionedTableContext.partitionName().getText());
            }
            if (partitionedTableContext.segmentAttributesClause() != null) {
                this.dealWithSegmentAttributesClause(partitionedTableContext.segmentAttributesClause(), partitionedTable);
            }
            partitionedTables.add(partitionedTable);
        }
        indexPartition.setPartitionedTables(partitionedTables);
    }

    private void dealWithSegmentAttributesClause(List<OracleParser.SegmentAttributesClauseContext> segmentAttributesClauses, PartitionedTable partitionedTable) {
        for (int i = 0; i < segmentAttributesClauses.size(); ++i) {
            OracleParser.SegmentAttributesClauseContext segmentAttributesClause = segmentAttributesClauses.get(i);
            if (segmentAttributesClause.tablespaceName == null) continue;
            partitionedTable.setTablespace(segmentAttributesClause.tablespaceName.getText());
        }
    }
}

