/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.ConstraintState;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.ReferencesClause;
import com.huawei.hwclouds.migration.oracle.model.TableConstraint;
import com.huawei.hwclouds.migration.oracle.model.TableName;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.util.OptionCommonUtil;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ConstraintStateVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TableNameVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class SqlTableConstraintVisitor
extends AbstractVisitor<TableConstraint> {
    private TableConstraint tableConstraint = new TableConstraint();

    @Override
    protected TableConstraint defaultResult() {
        return this.tableConstraint;
    }

    @Override
    public TableConstraint visitOutOfLineConstraint(OracleParser.OutOfLineConstraintContext ctx) {
        Identifier type;
        SqlNodeList<Identifier> nodeList;
        if (ctx.constraintName() != null) {
            this.visit((ParseTree)ctx.constraintName());
        }
        if (ctx.PRIMARY() != null || ctx.UNIQUE() != null) {
            String name = ctx.UNIQUE() != null ? "UNIQUE" : "PRIMARY KEY";
            Identifier type2 = new Identifier(name);
            this.tableConstraint.setConstraintType(type2);
            nodeList = OptionCommonUtil.optionColumn(ctx.columnName());
            this.tableConstraint.setColumns(nodeList);
        }
        if (ctx.foreignKeyClause() != null) {
            type = new Identifier("FOREIGN KEY");
            this.tableConstraint.setConstraintType(type);
            OracleParser.ParenColumnListContext listContext = ctx.foreignKeyClause().parenColumnList();
            nodeList = OptionCommonUtil.optionColumn(listContext.columnList().columnName());
            this.tableConstraint.setColumns(nodeList);
            this.tableConstraint.setReferencesClause(this.getReferencesClause(ctx.foreignKeyClause().referencesClause()));
        }
        if (ctx.CHECK() != null) {
            type = new Identifier("CHECK");
            this.tableConstraint.setConstraintType(type);
        }
        if (ctx.constraintState() != null) {
            List<OracleParser.ConstraintStateContext> constraintStateContexts = ctx.constraintState();
            for (int i = 0; i < constraintStateContexts.size(); ++i) {
                ConstraintState constraintState = (ConstraintState)new ConstraintStateVisitor().visit((ParseTree)constraintStateContexts.get(i));
                this.tableConstraint.addConstraintStates(constraintState);
            }
        }
        return this.tableConstraint;
    }

    public ReferencesClause getReferencesClause(OracleParser.ReferencesClauseContext context) {
        ReferencesClause referencesClause = new ReferencesClause();
        referencesClause.setTableName((TableName)new TableNameVisitor().visit((ParseTree)context.tableviewName()));
        if (context.parenColumnList() != null) {
            SqlNodeList<Identifier> nodeList = OptionCommonUtil.optionColumn(context.parenColumnList().columnList().columnName());
            referencesClause.setColumns(nodeList);
        }
        if (context.CASCADE() != null) {
            referencesClause.setOnDeleteType("ON DELETE CASCADE");
        } else if (context.SET() != null) {
            referencesClause.setOnDeleteType("ON DELETE SET NULL");
        }
        return referencesClause;
    }

    @Override
    public TableConstraint visitConstraintName(OracleParser.ConstraintNameContext ctx) {
        this.tableConstraint.setConstraintName(new Identifier(ctx.getText()));
        return this.tableConstraint;
    }

    @Override
    public TableConstraint visitDropPrimaryKeyOrUniqueOrGenericClause(OracleParser.DropPrimaryKeyOrUniqueOrGenericClauseContext ctx) {
        if (ctx.UNIQUE() != null) {
            List<OracleParser.ColumnNameContext> columnNameContexts = ctx.columnName();
            this.setUnique(columnNameContexts);
        }
        if (ctx.constraintName() != null) {
            this.tableConstraint.setConstraintName(new Identifier(ctx.constraintName().getText()));
        }
        if (ctx.PRIMARY() != null) {
            this.tableConstraint.setConstraintType(new Identifier("PRIMARY KEY"));
        }
        this.tableConstraint.setCascade(ctx.CASCADE() != null);
        return this.tableConstraint;
    }

    @Override
    public TableConstraint visitModifyConstraintClause(OracleParser.ModifyConstraintClauseContext modifyContext) {
        if (modifyContext.PRIMARY() != null) {
            this.tableConstraint.setConstraintType(new Identifier("PRIMARY KEY"));
        }
        if (modifyContext.UNIQUE() != null) {
            List<OracleParser.ColumnNameContext> columnNameContexts = modifyContext.columnName();
            this.setUnique(columnNameContexts);
        }
        if (modifyContext.constraintName() != null) {
            this.tableConstraint.setConstraintName(new Identifier(modifyContext.constraintName().getText()));
        }
        this.tableConstraint.setCascade(modifyContext.CASCADE() != null);
        return this.tableConstraint;
    }

    public void setUnique(List<OracleParser.ColumnNameContext> columnNameContexts) {
        this.tableConstraint.setConstraintType(new Identifier("UNIQUE"));
        SqlNodeList<Identifier> columns = new SqlNodeList<Identifier>();
        for (int i = 0; i < columnNameContexts.size(); ++i) {
            columns.addNode(new Identifier(columnNameContexts.get(i).getText()));
        }
        this.tableConstraint.setColumns(columns);
    }
}

