/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.common.util.ParserRuntimeException;
import com.huawei.hwclouds.migration.oracle.model.AlterByAddPartition;
import com.huawei.hwclouds.migration.oracle.model.AlterByDropPartition;
import com.huawei.hwclouds.migration.oracle.model.AlterByExchangePartition;
import com.huawei.hwclouds.migration.oracle.model.AlterByMergePartition;
import com.huawei.hwclouds.migration.oracle.model.AlterByModifyPartition;
import com.huawei.hwclouds.migration.oracle.model.AlterBySplitPartition;
import com.huawei.hwclouds.migration.oracle.model.AlterByTruncatePartition;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.TableName;
import com.huawei.hwclouds.migration.oracle.model.TableOption;
import com.huawei.hwclouds.migration.oracle.model.TablePartitioningClauses;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TableNameVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TablePartitioningClausesVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public abstract class TableOptionVisitor<T>
extends AbstractVisitor<T> {
    protected abstract void addOption(TableOption var1);

    @Override
    public T visitAddTablePartition(OracleParser.AddTablePartitionContext ctx) {
        AlterByAddPartition alterByAddPartition = new AlterByAddPartition();
        TablePartitioningClauses tablePartitioningClauses = ctx.rangePartitionDescList() != null ? (TablePartitioningClauses)new TablePartitioningClausesVisitor().visit((ParseTree)ctx.rangePartitionDescList()) : (ctx.listPartitionDescList() != null ? (TablePartitioningClauses)new TablePartitioningClausesVisitor().visit((ParseTree)ctx.listPartitionDescList()) : (TablePartitioningClauses)new TablePartitioningClausesVisitor().visit((ParseTree)ctx.hashPartitionDesc()));
        tablePartitioningClauses.setOther(true);
        alterByAddPartition.setTablePartitioningClauses(tablePartitioningClauses);
        this.addOption(alterByAddPartition);
        return this.defaultResult();
    }

    @Override
    public T visitDropTablePartition(OracleParser.DropTablePartitionContext ctx) {
        AlterByDropPartition dropPartition = new AlterByDropPartition();
        if (ctx.partitionExtendedNames() != null) {
            List<OracleParser.PartitionKeyValueContext> partitionKeyValue;
            OracleParser.PartitionExtendedNamesContext partitionExtendedNames = ctx.partitionExtendedNames();
            List<OracleParser.PartitionNameContext> partitionNameContexts = partitionExtendedNames.partitionName();
            if (partitionNameContexts != null && partitionNameContexts.size() > 0) {
                SqlNodeList<Identifier> partitions = new SqlNodeList<Identifier>();
                for (int i = 0; i < partitionExtendedNames.partitionName().size(); ++i) {
                    partitions.addNode(new Identifier(partitionNameContexts.get(i).getText()));
                }
                dropPartition.setPartitions(partitions);
            }
            if ((partitionKeyValue = partitionExtendedNames.partitionKeyValue()) != null && partitionKeyValue.size() > 0) {
                SqlNodeList<Identifier> partitionsFor = new SqlNodeList<Identifier>();
                for (int i = 0; i < partitionKeyValue.size(); ++i) {
                    partitionsFor.addNode(new Identifier(partitionKeyValue.get(i).getText()));
                }
                dropPartition.setPartitionsFor(partitionsFor);
            }
        }
        if (ctx.subpartitionExtendedNames() != null) {
            throw new ParserRuntimeException("Not supported");
        }
        this.addOption(dropPartition);
        return this.defaultResult();
    }

    @Override
    public T visitMergeTablePartition(OracleParser.MergeTablePartitionContext ctx) {
        AlterByMergePartition mergePartition = new AlterByMergePartition();
        SqlNodeList<Identifier> oldPartitions = new SqlNodeList<Identifier>();
        List<OracleParser.PartitionNameContext> partitionNames = ctx.partitionNameList().partitionName();
        for (int i = 0; i < partitionNames.size(); ++i) {
            oldPartitions.addNode(new Identifier(partitionNames.get(i).getText()));
        }
        mergePartition.setOriPartitions(oldPartitions);
        mergePartition.setNewPartition(new Identifier(ctx.partitionName().getText()));
        this.addOption(mergePartition);
        return this.defaultResult();
    }

    @Override
    public T visitModifyTablePartition(OracleParser.ModifyTablePartitionContext ctx) {
        AlterByModifyPartition modifyPartition = new AlterByModifyPartition();
        modifyPartition.setPartition(new Identifier(ctx.partitionName().getText()));
        modifyPartition.setRebuild(ctx.REBUILD() != null);
        this.addOption(modifyPartition);
        return this.defaultResult();
    }

    @Override
    public T visitSplitTablePartition(OracleParser.SplitTablePartitionContext ctx) {
        List<OracleParser.LiteralContext> literal;
        AlterBySplitPartition splitPartition = new AlterBySplitPartition();
        splitPartition.setPartition(new Identifier(ctx.partitionName().getText()));
        if (ctx.splitPointClause() != null) {
            literal = ctx.splitPointClause().literal();
            SqlNodeList<Identifier> atInfos = this.getLiterals(literal);
            splitPartition.setAtInfos(atInfos);
        }
        if (ctx.splitValuesClause() != null) {
            literal = ctx.splitValuesClause().literal();
            SqlNodeList<Identifier> valuesInfos = this.getLiterals(literal);
            splitPartition.setValuesInfos(valuesInfos);
        }
        TablePartitioningClauses tablePartitioningClauses = null;
        if (ctx.rangePartitionDescList() != null) {
            tablePartitioningClauses = (TablePartitioningClauses)new TablePartitioningClausesVisitor().visit((ParseTree)ctx.rangePartitionDescList());
        } else if (ctx.listPartitionDescList() != null) {
            tablePartitioningClauses = (TablePartitioningClauses)new TablePartitioningClausesVisitor().visit((ParseTree)ctx.listPartitionDescList());
        }
        tablePartitioningClauses.setOther(true);
        splitPartition.setTablePartitioningClauses(tablePartitioningClauses);
        this.addOption(splitPartition);
        return this.defaultResult();
    }

    private SqlNodeList<Identifier> getLiterals(List<OracleParser.LiteralContext> literals) {
        SqlNodeList<Identifier> literalList = new SqlNodeList<Identifier>();
        for (int i = 0; i < literals.size(); ++i) {
            literalList.addNode(new Identifier(literals.get(i).getText()));
        }
        return literalList;
    }

    @Override
    public T visitTruncateTablePartition(OracleParser.TruncateTablePartitionContext ctx) {
        AlterByTruncatePartition truncatePartition = new AlterByTruncatePartition();
        if (ctx.partitionExtendedNames() != null) {
            if (ctx.partitionExtendedNames().partitionKeyValue() != null && ctx.partitionExtendedNames().partitionKeyValue().size() > 0) {
                SqlNodeList<Identifier> partitionKeyValues = this.setPartitionKeyValues(ctx.partitionExtendedNames());
                truncatePartition.setPartitionKeyValues(partitionKeyValues);
            }
            if (ctx.partitionExtendedNames().partitionName() != null && ctx.partitionExtendedNames().partitionName().size() > 0) {
                SqlNodeList<Identifier> partitionNames = this.setPartitionNames(ctx.partitionExtendedNames());
                truncatePartition.setPartitionNames(partitionNames);
            }
        }
        if (ctx.subpartitionExtendedNames() != null) {
            throw new ParserRuntimeException("Not supported");
        }
        truncatePartition.setCascade(ctx.CASCADE() != null);
        this.addOption(truncatePartition);
        return this.defaultResult();
    }

    public SqlNodeList<Identifier> setPartitionKeyValues(OracleParser.PartitionExtendedNamesContext partitionExtendedNames) {
        SqlNodeList<Identifier> partitionKeyValues = new SqlNodeList<Identifier>();
        List<OracleParser.PartitionKeyValueContext> keyValues = partitionExtendedNames.partitionKeyValue();
        for (int i = 0; i < keyValues.size(); ++i) {
            partitionKeyValues.addNode(new Identifier(keyValues.get(i).getText()));
        }
        return partitionKeyValues;
    }

    public SqlNodeList<Identifier> setPartitionNames(OracleParser.PartitionExtendedNamesContext partitionExtendedNames) {
        SqlNodeList<Identifier> partitionNames = new SqlNodeList<Identifier>();
        List<OracleParser.PartitionNameContext> partitionNameContexts = partitionExtendedNames.partitionName();
        for (int i = 0; i < partitionNameContexts.size(); ++i) {
            partitionNames.addNode(new Identifier(partitionNameContexts.get(i).getText()));
        }
        return partitionNames;
    }

    @Override
    public T visitExchangeTablePartition(OracleParser.ExchangeTablePartitionContext ctx) {
        AlterByExchangePartition exchangePartition = new AlterByExchangePartition();
        if (ctx.partitionExtendedNames() != null) {
            if (ctx.partitionExtendedNames().partitionKeyValue() != null && ctx.partitionExtendedNames().partitionKeyValue().size() > 0) {
                SqlNodeList<Identifier> partitionKeyValues = this.setPartitionKeyValues(ctx.partitionExtendedNames());
                exchangePartition.setPartitionsFor(partitionKeyValues);
            }
            if (ctx.partitionExtendedNames().partitionName() != null && ctx.partitionExtendedNames().partitionName().size() > 0) {
                SqlNodeList<Identifier> partitionNames = this.setPartitionNames(ctx.partitionExtendedNames());
                exchangePartition.setPartitions(partitionNames);
            }
        }
        exchangePartition.setWithTable((TableName)new TableNameVisitor().visit((ParseTree)ctx.tableviewName()));
        if (ctx.WITH().size() == 2) {
            exchangePartition.setValidationType("WITH");
        }
        if (ctx.WITHOUT() != null) {
            exchangePartition.setValidationType("WITHOUT");
        }
        if (ctx.INCLUDING() != null) {
            exchangePartition.setIndexType("INCLUDING");
        }
        if (ctx.EXCHANGE() != null) {
            exchangePartition.setIndexType("EXCHANGE");
        }
        this.addOption(exchangePartition);
        return this.defaultResult();
    }

    @Override
    public T visitCoalesceTablePartition(OracleParser.CoalesceTablePartitionContext ctx) {
        throw new ParserRuntimeException("Not supported");
    }

    @Override
    public T visitAlterIntervalPartition(OracleParser.AlterIntervalPartitionContext ctx) {
        throw new ParserRuntimeException("Not supported");
    }
}

