/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.HashPartitionsByQuantity;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.Literal;
import com.huawei.hwclouds.migration.oracle.model.PartitionDefinition;
import com.huawei.hwclouds.migration.oracle.model.PartitionOption;
import com.huawei.hwclouds.migration.oracle.model.PartitioningStorage;
import com.huawei.hwclouds.migration.oracle.model.StringFunction;
import com.huawei.hwclouds.migration.oracle.model.SystemFunction;
import com.huawei.hwclouds.migration.oracle.model.TablePartitioningClauses;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SqlPartitionOptionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.StringFunctionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SystemFunctionVisitor;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class TablePartitioningClausesVisitor
extends AbstractVisitor<TablePartitioningClauses> {
    private TablePartitioningClauses tablePartitioningClauses = new TablePartitioningClauses();

    @Override
    protected TablePartitioningClauses defaultResult() {
        return this.tablePartitioningClauses;
    }

    @Override
    public TablePartitioningClauses visitRangePartitions(OracleParser.RangePartitionsContext ctx) {
        this.tablePartitioningClauses.setPartitionFunction(TablePartitioningClauses.PartitionFunction.RANGE);
        SqlNodeList<Identifier> columnName = new SqlNodeList<Identifier>();
        for (int i = 0; i < ctx.columnName().size(); ++i) {
            columnName.addNode(new Identifier(ctx.columnName(i).getText()));
        }
        this.tablePartitioningClauses.setColumnName(columnName);
        if (ctx.INTERVAL() != null) {
            this.dealWithInterval(ctx.expression(), ctx.STORE(), ctx.tablespace());
        }
        List<OracleParser.RangeValuesPartitionContext> rangeValuesPartitions = ctx.rangeValuesPartition();
        SqlNodeList<PartitionDefinition> partitionDefs = new SqlNodeList<PartitionDefinition>();
        for (int i = 0; i < rangeValuesPartitions.size(); ++i) {
            OracleParser.RangeValuesPartitionContext rangeValuesPartition = rangeValuesPartitions.get(i);
            PartitionDefinition def = new PartitionDefinition();
            if (rangeValuesPartition.partitionName() != null) {
                def.setUid(new Identifier(rangeValuesPartition.partitionName().getText()));
            }
            def.setExpressions(this.getExpressList(rangeValuesPartition.rangeValuesClause().literal(), false, null));
            if (!rangeValuesPartition.tablePartitionDescription().isEmpty()) {
                def.setPartitionOption(this.getPartitionOptionList(null, rangeValuesPartition.tablePartitionDescription()));
            }
            partitionDefs.addNode(def);
        }
        this.tablePartitioningClauses.setPartitionDefinition(partitionDefs);
        return this.defaultResult();
    }

    private void dealWithInterval(OracleParser.ExpressionContext expression, TerminalNode store, List<OracleParser.TablespaceContext> tablespaceContext) {
        this.tablePartitioningClauses.setInterval(true);
        this.tablePartitioningClauses.setIntervalExpression((Expression)new ExpressionVisitor().visit((ParseTree)expression));
        if (store != null) {
            ArrayList<String> tableSpaceList = new ArrayList<String>();
            for (OracleParser.TablespaceContext tablespace : tablespaceContext) {
                tableSpaceList.add(tablespace.getText());
            }
            this.tablePartitioningClauses.setStoreInTableSpaces(tableSpaceList);
        }
    }

    @Override
    public TablePartitioningClauses visitListPartitions(OracleParser.ListPartitionsContext ctx) {
        this.tablePartitioningClauses.setPartitionFunction(TablePartitioningClauses.PartitionFunction.LIST);
        SqlNodeList<Identifier> columnName = new SqlNodeList<Identifier>();
        columnName.addNode(new Identifier(ctx.columnName().getText()));
        this.tablePartitioningClauses.setColumnName(columnName);
        List<OracleParser.ListValuesPartitionContext> listValuesPartitions = ctx.listValuesPartition();
        SqlNodeList<PartitionDefinition> partitionDefs = new SqlNodeList<PartitionDefinition>();
        for (int i = 0; i < listValuesPartitions.size(); ++i) {
            OracleParser.ListValuesPartitionContext listValuesPartition = listValuesPartitions.get(i);
            PartitionDefinition def = new PartitionDefinition();
            if (listValuesPartition.partitionName() != null) {
                def.setUid(new Identifier(listValuesPartition.partitionName().getText()));
            }
            boolean isTemp = listValuesPartition.listValuesClause().TIMESTAMP(i) != null;
            def.setExpressions(this.getExpressList(listValuesPartition.listValuesClause().literal(), isTemp, listValuesPartition.listValuesClause().DEFAULT()));
            if (!listValuesPartition.tablePartitionDescription().isEmpty()) {
                def.setPartitionOption(this.getPartitionOptionList(null, listValuesPartition.tablePartitionDescription()));
            }
            partitionDefs.addNode(def);
        }
        this.tablePartitioningClauses.setPartitionDefinition(partitionDefs);
        return this.defaultResult();
    }

    @Override
    public TablePartitioningClauses visitHashPartitions(OracleParser.HashPartitionsContext ctx) {
        this.tablePartitioningClauses.setPartitionFunction(TablePartitioningClauses.PartitionFunction.HASH);
        SqlNodeList<Identifier> columnName = new SqlNodeList<Identifier>();
        for (int i = 0; i < ctx.columnName().size(); ++i) {
            columnName.addNode(new Identifier(ctx.columnName(i).getText()));
        }
        this.tablePartitioningClauses.setColumnName(columnName);
        if (ctx.individualHashPartitions() != null) {
            SqlNodeList<PartitioningStorage> individualHashPartitions = new SqlNodeList<PartitioningStorage>();
            OracleParser.IndividualHashPartitionsContext individualHashPartitionsContext = ctx.individualHashPartitions();
            for (int i = 0; i < individualHashPartitionsContext.partitioningStorage().size(); ++i) {
                PartitioningStorage partitioningStorage = new PartitioningStorage();
                if (individualHashPartitionsContext.partitioningStorage().get(i).partitionName() != null) {
                    partitioningStorage.setPartitionName(individualHashPartitionsContext.partitioningStorage().get(i).partitionName().getText());
                }
                if (individualHashPartitionsContext.partitioningStorage().get(i).partitioningStorageClause() != null) {
                    partitioningStorage.setPartitioningStorageClause(this.dealWithPartitioningStorageClause(individualHashPartitionsContext.partitioningStorage().get(i).partitioningStorageClause()));
                }
                individualHashPartitions.addNode(partitioningStorage);
            }
            this.tablePartitioningClauses.setIndividualHashPartitions(individualHashPartitions);
        } else {
            this.tablePartitioningClauses.setHashPartitionsByQuantity(this.dealWithHashPartitionsByQuantity(ctx.hashPartitionsByQuantity()));
        }
        return this.defaultResult();
    }

    private HashPartitionsByQuantity dealWithHashPartitionsByQuantity(OracleParser.HashPartitionsByQuantityContext hashPartitionsByQuantityContext) {
        String compression;
        List<String> tableSpaceList;
        HashPartitionsByQuantity hashPartitionsByQuantity = new HashPartitionsByQuantity();
        hashPartitionsByQuantity.setHashPartitionQuantity(hashPartitionsByQuantityContext.hashPartitionQuantity().getText());
        if (hashPartitionsByQuantityContext.firTableSpace != null) {
            tableSpaceList = this.getTableSpaceList(hashPartitionsByQuantityContext.firTableSpace);
            hashPartitionsByQuantity.setTableSpaceList(tableSpaceList);
        }
        if (hashPartitionsByQuantityContext.tableCompression() != null) {
            compression = "";
            for (int i = 0; i < hashPartitionsByQuantityContext.tableCompression().getChildCount(); ++i) {
                compression = compression + hashPartitionsByQuantityContext.tableCompression().getChild(i).getText() + " ";
            }
            hashPartitionsByQuantity.setCompression(compression);
        } else if (hashPartitionsByQuantityContext.keyCompression() != null) {
            compression = "";
            for (int i = 0; i < hashPartitionsByQuantityContext.keyCompression().getChildCount(); ++i) {
                compression = compression + hashPartitionsByQuantityContext.keyCompression().getChild(i).getText() + " ";
            }
            hashPartitionsByQuantity.setCompression(compression);
        }
        if (hashPartitionsByQuantityContext.secTableSpace != null) {
            tableSpaceList = this.getTableSpaceList(hashPartitionsByQuantityContext.secTableSpace);
            hashPartitionsByQuantity.setTableSpaceListForOverFlow(tableSpaceList);
        }
        return hashPartitionsByQuantity;
    }

    private List<String> getTableSpaceList(OracleParser.TableSpaceListContext p) {
        ArrayList<String> tableSpaceList = new ArrayList<String>();
        for (int i = 0; i < p.tablespace().size(); ++i) {
            tableSpaceList.add(p.tablespace().get(i).getText());
        }
        return tableSpaceList;
    }

    private String dealWithPartitioningStorageClause(OracleParser.PartitioningStorageClauseContext partitioningStorageClauseContext) {
        String partitioningStorageClause = "";
        for (int i = 0; i < partitioningStorageClauseContext.getChildCount(); ++i) {
            if (partitioningStorageClauseContext.getChild(i).getChildCount() > 0) {
                for (int j = 0; j < partitioningStorageClauseContext.getChild(i).getChildCount(); ++j) {
                    partitioningStorageClause = partitioningStorageClause + partitioningStorageClauseContext.getChild(i).getChild(j).getText() + " ";
                }
                continue;
            }
            partitioningStorageClause = partitioningStorageClause + partitioningStorageClauseContext.getChild(i).getText() + " ";
        }
        return partitioningStorageClause;
    }

    @Override
    public TablePartitioningClauses visitCompositeListPartitions(OracleParser.CompositeListPartitionsContext ctx) {
        SqlNodeList<Identifier> columnName = new SqlNodeList<Identifier>();
        columnName.addNode(new Identifier(ctx.columnName().getText()));
        this.tablePartitioningClauses.setColumnName(columnName);
        this.visitListPartitionDescList(ctx.listPartitionDescList());
        return this.defaultResult();
    }

    @Override
    public TablePartitioningClauses visitCompositeRangePartitions(OracleParser.CompositeRangePartitionsContext ctx) {
        SqlNodeList<Identifier> columnName = new SqlNodeList<Identifier>();
        for (int i = 0; i < ctx.columnName().size(); ++i) {
            columnName.addNode(new Identifier(ctx.columnName(i).getText()));
        }
        this.tablePartitioningClauses.setColumnName(columnName);
        this.visitRangePartitionDescList(ctx.rangePartitionDescList());
        if (ctx.INTERVAL() != null) {
            this.dealWithInterval(ctx.expression(), ctx.STORE(), ctx.tablespace());
        }
        return this.defaultResult();
    }

    @Override
    public TablePartitioningClauses visitCompositeHashPartitions(OracleParser.CompositeHashPartitionsContext ctx) {
        return this.defaultResult();
    }

    private SqlNodeList<Literal> getExpressList(List<OracleParser.LiteralContext> literalCtx, boolean isTimeStamp, TerminalNode defaultValue) {
        SqlNodeList<Literal> literalSqlNodeList = new SqlNodeList<Literal>();
        if (literalCtx != null) {
            for (int i = 0; i < literalCtx.size(); ++i) {
                Literal literalNode = new Literal();
                if (literalCtx.get(i).systemFunction() != null) {
                    literalNode.setSystemFunction((SystemFunction)new SystemFunctionVisitor().visit((ParseTree)literalCtx.get(i).systemFunction()));
                } else if (literalCtx.get(i).stringFunction() != null) {
                    literalNode.setStringFunction((StringFunction)new StringFunctionVisitor().visit((ParseTree)literalCtx.get(i).stringFunction()));
                } else {
                    String identifier = literalCtx.get(i).getText();
                    if (isTimeStamp) {
                        identifier = "TIMESTAMP " + identifier;
                    }
                    literalNode.setLiteral(identifier);
                }
                literalSqlNodeList.addNode(literalNode);
            }
        }
        if (defaultValue != null) {
            Literal defaultLiteral = new Literal();
            defaultLiteral.setLiteral("DEFAULT");
            literalSqlNodeList.addNode(defaultLiteral);
        }
        return literalSqlNodeList;
    }

    private SqlNodeList<PartitionOption> getPartitionOptionList(List<OracleParser.TablePartitionDescriptionContext> contexts, OracleParser.TablePartitionDescriptionContext context) {
        SqlNodeList<PartitionOption> partitionOption = new SqlNodeList<PartitionOption>();
        if (contexts != null) {
            for (int j = 0; j < contexts.size(); ++j) {
                PartitionOption sqlPartitionOption = (PartitionOption)new SqlPartitionOptionVisitor().visit((ParseTree)contexts.get(j));
                partitionOption.addNode(sqlPartitionOption);
            }
        }
        if (context != null) {
            PartitionOption sqlPartitionOption = (PartitionOption)new SqlPartitionOptionVisitor().visit((ParseTree)context);
            partitionOption.addNode(sqlPartitionOption);
        }
        return partitionOption;
    }

    @Override
    public TablePartitioningClauses visitRangePartitionDescList(OracleParser.RangePartitionDescListContext ctx) {
        this.tablePartitioningClauses.setPartitionFunction(TablePartitioningClauses.PartitionFunction.RANGE);
        List<OracleParser.RangePartitionDescContext> rangePartitionDescList = ctx.rangePartitionDesc();
        SqlNodeList<PartitionDefinition> partitionDefs = new SqlNodeList<PartitionDefinition>();
        for (int i = 0; i < rangePartitionDescList.size(); ++i) {
            OracleParser.RangePartitionDescContext rangePartitionDesc = rangePartitionDescList.get(i);
            PartitionDefinition def = new PartitionDefinition();
            if (rangePartitionDesc.partitionName() != null) {
                def.setUid(new Identifier(rangePartitionDesc.partitionName().getText()));
            }
            def.setExpressions(this.getExpressList(rangePartitionDesc.rangeValuesClause().literal(), false, null));
            if (rangePartitionDesc.tablePartitionDescription() != null) {
                def.setPartitionOption(this.getPartitionOptionList(null, rangePartitionDesc.tablePartitionDescription()));
            }
            partitionDefs.addNode(def);
        }
        this.tablePartitioningClauses.setPartitionDefinition(partitionDefs);
        return this.defaultResult();
    }

    @Override
    public TablePartitioningClauses visitListPartitionDescList(OracleParser.ListPartitionDescListContext ctx) {
        this.tablePartitioningClauses.setPartitionFunction(TablePartitioningClauses.PartitionFunction.LIST);
        List<OracleParser.ListPartitionDescContext> listPartitionDescList = ctx.listPartitionDesc();
        SqlNodeList<PartitionDefinition> partitionDefs = new SqlNodeList<PartitionDefinition>();
        for (int i = 0; i < listPartitionDescList.size(); ++i) {
            OracleParser.ListPartitionDescContext listPartitionDesc = listPartitionDescList.get(i);
            PartitionDefinition def = new PartitionDefinition();
            if (listPartitionDesc.partitionName() != null) {
                def.setUid(new Identifier(listPartitionDesc.partitionName().getText()));
            }
            boolean isTemp = listPartitionDesc.listValuesClause().TIMESTAMP() != null;
            def.setExpressions(this.getExpressList(listPartitionDesc.listValuesClause().literal(), isTemp, listPartitionDesc.listValuesClause().DEFAULT()));
            if (!listPartitionDesc.tablePartitionDescription().isEmpty()) {
                def.setPartitionOption(this.getPartitionOptionList(null, listPartitionDesc.tablePartitionDescription()));
            }
            partitionDefs.addNode(def);
        }
        return this.defaultResult();
    }

    @Override
    public TablePartitioningClauses visitHashPartitionDesc(OracleParser.HashPartitionDescContext ctx) {
        return this.defaultResult();
    }
}

