/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.CommitStatement;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.RollbackStatement;
import com.huawei.hwclouds.migration.oracle.model.SetConstraints;
import com.huawei.hwclouds.migration.oracle.model.SetTransaction;
import com.huawei.hwclouds.migration.oracle.model.TransactionControlStatements;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.util.OptionCommonUtil;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;

public class TransactionControlStatementsVisitor
extends AbstractVisitor<TransactionControlStatements> {
    private TransactionControlStatements statements = new TransactionControlStatements();

    @Override
    protected TransactionControlStatements defaultResult() {
        return this.statements;
    }

    @Override
    public TransactionControlStatements visitSetTransactionCommand(OracleParser.SetTransactionCommandContext ctx) {
        SetTransaction setTransaction = new SetTransaction();
        if (ctx.transactionRead() != null) {
            if (ctx.transactionRead().ONLY() != null) {
                setTransaction.setTransactionRead("READ ONLY");
            } else {
                setTransaction.setTransactionRead("READ WRITE");
            }
        }
        if (ctx.transactionIsolation() != null) {
            if (ctx.transactionIsolation().SERIALIZABLE() != null) {
                setTransaction.setTransactionIsolation("ISOLATION LEVEL SERIALIZABLE");
            } else {
                setTransaction.setTransactionIsolation("ISOLATION LEVEL READ COMMITTED");
            }
        }
        if (ctx.transactionUseRollback() != null) {
            String rollBack = "USE ROLLBACK SEGMENT ";
            setTransaction.setTransactionIsolation(rollBack + ctx.transactionUseRollback().rollbackSegmentName().getText());
        }
        if (ctx.quotedString() != null) {
            setTransaction.setNameString(ctx.quotedString().getText());
        }
        this.statements.setSetTransaction(setTransaction);
        return this.defaultResult();
    }

    @Override
    public TransactionControlStatements visitSetConstraintCommand(OracleParser.SetConstraintCommandContext ctx) {
        SetConstraints setConstraints = new SetConstraints();
        if (ctx.constraintName() != null) {
            SqlNodeList<Identifier> constraints = new SqlNodeList<Identifier>();
            for (int i = 0; i < ctx.constraintName().size(); ++i) {
                constraints.addNode(new Identifier(ctx.constraintName().get(i).getText()));
            }
            setConstraints.setConstraints(constraints);
        }
        setConstraints.setAll(ctx.ALL() != null);
        if (ctx.IMMEDIATE() != null) {
            setConstraints.setConsType(new Identifier("IMMEDIATE"));
        } else {
            setConstraints.setConsType(new Identifier("DEFERRED"));
        }
        this.statements.setSetConstraints(setConstraints);
        return this.defaultResult();
    }

    @Override
    public TransactionControlStatements visitCommitStatement(OracleParser.CommitStatementContext ctx) {
        CommitStatement commitStatement = new CommitStatement();
        commitStatement.setWork(ctx.WORK() != null);
        if (ctx.FORCE() != null) {
            commitStatement.setCommitType("FORCE");
            if (ctx.expression() != null && ctx.expression().size() > 0) {
                commitStatement.setExpressionList(OptionCommonUtil.getSqlExpression(ctx.expression()));
                if (ctx.CORRUPT_XID() != null) {
                    commitStatement.setForceType("CORRUPT_XID");
                }
            } else {
                commitStatement.setForceType("CORRUPT_XID_ALL");
            }
        }
        if (ctx.COMMENT() != null) {
            commitStatement.setCommitType("COMMENT");
            commitStatement.setExpressionList(OptionCommonUtil.getSqlExpression(ctx.expression()));
        }
        if (ctx.writeClause() != null) {
            commitStatement.setWriteClause(OptionCommonUtil.getWriteClause(ctx.writeClause()));
        }
        this.statements.setCommitStatement(commitStatement);
        return this.defaultResult();
    }

    @Override
    public TransactionControlStatements visitRollbackStatement(OracleParser.RollbackStatementContext ctx) {
        RollbackStatement rollbackStatement = new RollbackStatement();
        rollbackStatement.setWork(ctx.WORK() != null);
        if (ctx.savepointName() != null) {
            rollbackStatement.setSavepointName(ctx.savepointName().getText());
            rollbackStatement.setSavepoint(ctx.SAVEPOINT() != null);
        }
        if (ctx.quotedString() != null) {
            rollbackStatement.setForceName(ctx.quotedString().getText());
        }
        this.statements.setRollbackStatement(rollbackStatement);
        return this.defaultResult();
    }

    @Override
    public TransactionControlStatements visitSavepointStatement(OracleParser.SavepointStatementContext ctx) {
        this.statements.setSavePointName(ctx.savepointName().getText());
        return this.defaultResult();
    }
}

