/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.DefaultValuePart;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.FieldSpec;
import com.huawei.hwclouds.migration.oracle.model.RefCursorTypeDef;
import com.huawei.hwclouds.migration.oracle.model.TableIndexedByPart;
import com.huawei.hwclouds.migration.oracle.model.TableTypeDef;
import com.huawei.hwclouds.migration.oracle.model.TypeDeclaration;
import com.huawei.hwclouds.migration.oracle.model.TypeSpec;
import com.huawei.hwclouds.migration.oracle.model.VarrayTypeDef;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TypeSpecVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.VarrayTypeDefVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class TypeDeclarationVisitor
extends AbstractVisitor<TypeDeclaration> {
    private TypeDeclaration typeDeclaration = new TypeDeclaration();

    @Override
    protected TypeDeclaration defaultResult() {
        return this.typeDeclaration;
    }

    @Override
    public TypeDeclaration visitTypeDeclaration(OracleParser.TypeDeclarationContext ctx) {
        this.typeDeclaration.setIdentifier(ctx.identifier().getText());
        if (ctx.tableTypeDef() != null) {
            OracleParser.TableTypeDefContext tableTypeDefContext = ctx.tableTypeDef();
            TableTypeDef tableTypeDef = new TableTypeDef();
            tableTypeDef.setTypeSpec((TypeSpec)new TypeSpecVisitor().visit((ParseTree)tableTypeDefContext.typeSpec()));
            if (tableTypeDefContext.tableIndexedByPart() != null) {
                TableIndexedByPart tableIndexedByPart = new TableIndexedByPart();
                tableIndexedByPart.setIndexKeyword(tableTypeDefContext.tableIndexedByPart().idx1 != null ? "INDEXED" : "INDEX");
                tableIndexedByPart.setTypeSpec((TypeSpec)new TypeSpecVisitor().visit((ParseTree)tableTypeDefContext.tableIndexedByPart().typeSpec()));
                tableTypeDef.setTableIndexedByPart(tableIndexedByPart);
            }
            tableTypeDef.setExistNotNull(tableTypeDefContext.NOT() != null);
            this.typeDeclaration.setTableTypeDef(tableTypeDef);
        } else if (ctx.varrayTypeDef() != null) {
            this.typeDeclaration.setVarrayTypeDef((VarrayTypeDef)new VarrayTypeDefVisitor().visit((ParseTree)ctx.varrayTypeDef()));
        } else if (ctx.recordTypeDef() != null) {
            OracleParser.RecordTypeDefContext recordTypeDefContext = ctx.recordTypeDef();
            SqlNodeList<FieldSpec> recordTypeDef = new SqlNodeList<FieldSpec>();
            for (int i = 0; i < recordTypeDefContext.fieldSpec().size(); ++i) {
                recordTypeDef.addNode(this.getFieldSpec(recordTypeDefContext.fieldSpec().get(i)));
            }
            this.typeDeclaration.setRecordTypeDef(recordTypeDef);
        } else {
            RefCursorTypeDef refCursorTypeDef = new RefCursorTypeDef();
            refCursorTypeDef.setRefCursor("REF CURSOR");
            if (ctx.refCursorTypeDef().typeSpec() != null) {
                refCursorTypeDef.setTypeSpec((TypeSpec)new TypeSpecVisitor().visit((ParseTree)ctx.refCursorTypeDef().typeSpec()));
            }
            this.typeDeclaration.setRefCursorTypeDef(refCursorTypeDef);
        }
        return this.defaultResult();
    }

    private FieldSpec getFieldSpec(OracleParser.FieldSpecContext ctx) {
        FieldSpec fieldSpec = new FieldSpec();
        fieldSpec.setColumnName(ctx.columnName().getText());
        if (ctx.typeSpec() != null) {
            fieldSpec.setTypeSpec((TypeSpec)new TypeSpecVisitor().visit((ParseTree)ctx.typeSpec()));
        }
        fieldSpec.setExistNotNull(ctx.NOT() != null);
        if (ctx.defaultValuePart() != null) {
            DefaultValuePart defaultvaluePart = new DefaultValuePart();
            defaultvaluePart.setDefaultForm(ctx.defaultValuePart().ASSIGN_OP() != null ? ctx.defaultValuePart().ASSIGN_OP().getText() : "DEFAULT");
            defaultvaluePart.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)ctx.defaultValuePart().expression()));
            fieldSpec.setDefaultValuePart(defaultvaluePart);
            fieldSpec.setDefaultValuePart(defaultvaluePart);
        }
        return fieldSpec;
    }
}

