/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.ColumnDefinition;
import com.huawei.hwclouds.migration.oracle.model.ConstraintState;
import com.huawei.hwclouds.migration.oracle.model.UsingIndex;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.util.SqlWriteUtil;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=ColumnDefinition.class)
public class ColumnDefinitionUnParser
implements UnParser<ColumnDefinition> {
    @Override
    public void unParse(ColumnDefinition sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getColumnName() != null) {
            sqlNode.getColumnName().unParse(writer, context);
        }
        if (sqlNode.getDataType() != null) {
            sqlNode.getDataType().unParse(writer, context);
        }
        if (sqlNode.getTypeName() != null) {
            SqlWriteUtil.typeNameExchange(writer, sqlNode.getTypeName());
        }
        writer.writeSpace(1);
        if (sqlNode.getDefaultValue() != null) {
            if (sqlNode.getDefaultValue().getValue() != null) {
                writer.append("DEFAULT").writeSpace(1);
                sqlNode.getDefaultValue().unParse(writer, context);
            } else {
                writer.append("DEFAULT NULL").writeSpace(1);
            }
        }
        if (sqlNode.getNonNotNon() != null) {
            if (sqlNode.getNonNotNon().isNull()) {
                writer.append("NULL").writeSpace(1);
            } else {
                writer.append("NOT NULL").writeSpace(1);
            }
        }
        if (sqlNode.isPrimaryKey()) {
            writer.append("PRIMARY KEY").writeSpace(1);
        }
        if (sqlNode.isUniqueKey()) {
            writer.append("UNIQUE").writeSpace(1);
        }
        if (sqlNode.getCheckConstraint() != null) {
            writer.append("CHECK").writeSpace(1);
            writer.append("(").writeSpace(1);
            sqlNode.getCheckConstraint().getCondition().unParse(writer, context);
            writer.append(")").writeSpace(1);
            if (sqlNode.getCheckConstraint().isExistDisable()) {
                writer.append("DISABLE");
            }
        }
        this.dealWithConstraintStates(writer, context, sqlNode.getConstraintStates());
    }

    private void dealWithConstraintStates(SqlWriter writer, UnParserContext context, SqlNodeList<ConstraintState> constraintStates) {
        List<ConstraintState> statesNodes = constraintStates.getNodes();
        if (constraintStates != null && statesNodes.size() > 0) {
            for (int i = 0; i < statesNodes.size(); ++i) {
                ConstraintState constraintState = statesNodes.get(i);
                UsingIndex usingIndex = constraintState.getUsingIndex();
                if (usingIndex != null) {
                    writer.append(" USING INDEX ");
                    if (usingIndex.getIndexName() != null) {
                        writer.append(usingIndex.getIndexName().getIdentifier());
                    }
                    if (usingIndex.getCreateIndex() != null) {
                        usingIndex.getCreateIndex().unParse(writer, context);
                    }
                } else {
                    writer.writeSpace(1).append(constraintState.getStateConstants());
                }
                writer.writeSpace(1);
            }
        }
    }
}

