/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.util.CommonUtils;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.CommentOn;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CommentOn.class)
public class CommentOnUnParser
implements UnParser<CommentOn> {
    @Override
    public void unParse(CommentOn sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("COMMENT ON").writeSpace(1);
        String commentOnType = sqlNode.getCommentOnType().getIdentifier();
        writer.append(commentOnType).writeSpace(1);
        if (commentOnType.equals("COLUMN")) {
            String columnName = CommonUtils.doubleQuoteFullColumn(sqlNode.getColumn().getIdentifier());
            writer.append(columnName).writeSpace(1);
        }
        if (commentOnType.equals("TABLE")) {
            sqlNode.getTableName().unParse(writer, context);
            writer.writeSpace(1);
        }
        writer.append("IS").writeSpace(1);
        writer.append(sqlNode.getCommentValue().getIdentifier());
    }
}

