/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.util.ConvertUtil;
import com.huawei.hwclouds.migration.common.util.QuoteUtils;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.BindVariableOrDigit;
import com.huawei.hwclouds.migration.oracle.model.Constant;
import com.huawei.hwclouds.migration.oracle.model.IntervalConstant;
import com.huawei.hwclouds.migration.oracle.model.TimestampConstant;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=Constant.class)
public class ConstantUnParser
implements UnParser<Constant> {
    @Override
    public void unParse(Constant sqlNode, SqlWriter writer, UnParserContext context) {
        String[] column;
        if (!context.isScalarInWhereClause()) {
            String input;
            if (sqlNode.getNumeric() != null) {
                writer.append(sqlNode.getNumeric()).writeSpace(1);
            }
            if (sqlNode.getQuotedString() != null) {
                input = ConvertUtil.keywordConvert(sqlNode.getQuotedString());
                if (context.isExecuteImmediate()) {
                    input = QuoteUtils.removeAllQuote(input);
                }
                input = this.dealWithForLoopCount(input);
                writer.append(input).writeSpace(1);
            }
            if (sqlNode.getOtherConstant() != null) {
                writer.append(sqlNode.getOtherConstant()).writeSpace(1);
            }
            if (sqlNode.getDateConstant() != null) {
                writer.append("DATE");
                input = ConvertUtil.keywordConvert(sqlNode.getDateConstant());
                writer.append(input).writeSpace(1);
            }
            if (sqlNode.getTimestampConstant() != null) {
                this.dealTimestampConstant(sqlNode.getTimestampConstant(), writer, context);
            }
            if (sqlNode.getIntervalConstant() != null) {
                this.dealIntervalConstant(sqlNode.getIntervalConstant(), writer, context);
            }
        } else if (sqlNode.getQuotedString() != null && (column = sqlNode.getQuotedString().split("\\.")).length == 2 && column[0].equalsIgnoreCase(context.getAsNameForScalar())) {
            context.getColumnInWhereClause().add(ConvertUtil.keywordConvert(column[1]));
        }
    }

    private String dealWithForLoopCount(String input) {
        String variableName = input;
        if (variableName.toLowerCase(Locale.ROOT).contains(".count")) {
            String tableName = variableName.replaceAll("(?i)(.count)", "");
            variableName = "(SELECT COUNT(*) FROM " + tableName + ") ";
        }
        return variableName;
    }

    private void dealTimestampConstant(TimestampConstant timestampConstant, SqlWriter writer, UnParserContext context) {
        writer.append(" TIMESTAMP ");
        if (timestampConstant.getStampString() != null) {
            writer.append(timestampConstant.getStampString()).writeSpace(1);
        } else {
            timestampConstant.getStampVariable().unParse(writer, context);
        }
        if (timestampConstant.getZoneString() != null) {
            writer.append(" AT TIME ZONE ").append(timestampConstant.getZoneString());
        }
    }

    private void dealIntervalConstant(IntervalConstant intervalConstant, SqlWriter writer, UnParserContext context) {
        writer.append(" INTERVAL ");
        if (intervalConstant.getIntervalString() != null) {
            writer.append(intervalConstant.getIntervalString());
        }
        if (intervalConstant.getIntervalVariable() != null) {
            intervalConstant.getIntervalVariable().unParse(writer, context);
        }
        if (intervalConstant.getIntervalPart() != null) {
            intervalConstant.getIntervalPart().unParse(writer, context);
        }
        writer.writeSpace(1).append(intervalConstant.getDateType()).writeSpace(1);
        if (intervalConstant.getBindVariableOrDigits() != null) {
            List<BindVariableOrDigit> bindVariableOrDigits = intervalConstant.getBindVariableOrDigits();
            writer.append(" ( ");
            for (int i = 0; i < bindVariableOrDigits.size(); ++i) {
                this.dealBindVariableOrDigit(bindVariableOrDigits.get(i), writer, context);
                if (i == bindVariableOrDigits.size() - 1) continue;
                writer.append(", ");
            }
            writer.append(" ) ");
        }
        this.dealToType(intervalConstant, writer, context);
    }

    private void dealBindVariableOrDigit(BindVariableOrDigit bindVariableOrDigit, SqlWriter writer, UnParserContext context) {
        if (bindVariableOrDigit.getBindVariable() != null) {
            bindVariableOrDigit.getBindVariable().unParse(writer, context);
        } else {
            writer.append(bindVariableOrDigit.getDigit());
        }
    }

    private void dealToType(IntervalConstant intervalConstant, SqlWriter writer, UnParserContext context) {
        writer.append(" TO ");
        if (intervalConstant.isToDay()) {
            writer.append("DAY ");
        }
        if (intervalConstant.isToHour()) {
            writer.append("HOUR ");
        }
        if (intervalConstant.isToMinute()) {
            writer.append("MINUTE ");
        }
        if (intervalConstant.isToSecond()) {
            writer.append("SECOND ");
        }
        if (intervalConstant.getSecBindOrDigit() != null) {
            this.dealBindVariableOrDigit(intervalConstant.getSecBindOrDigit(), writer, context);
        }
    }
}

