/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.util.QuoteUtils;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.CreateIndex;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.IndexColumnName;
import com.huawei.hwclouds.migration.oracle.model.IndexOptions;
import com.huawei.hwclouds.migration.oracle.model.IndexPartition;
import com.huawei.hwclouds.migration.oracle.model.PartitionedTable;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateIndex.class)
public class CreateIndexUnParser
implements UnParser<CreateIndex> {
    @Override
    public void unParse(CreateIndex sqlNode, SqlWriter writer, UnParserContext context) {
        int i;
        writer.append("CREATE").writeSpace(1);
        String indexType = sqlNode.getIndexType();
        if (indexType != null) {
            if (indexType.equals("BITMAP")) {
                writer.append("/* BITMAP */").writeSpace(1);
            }
            if (indexType.equals("UNIQUE")) {
                writer.append("UNIQUE").writeSpace(1);
            }
        }
        writer.append("INDEX").writeSpace(1);
        this.createIndexNameByArgs(sqlNode, writer, context);
        writer.writeSpace(1).append("ON").writeSpace(1);
        sqlNode.getTableName().unParse(writer, context);
        if (sqlNode.getTableNameAlias() != null) {
            writer.writeSpace(1).append(sqlNode.getTableNameAlias());
        }
        writer.append("(").writeSpace(1);
        List<IndexColumnName> indexColumns = sqlNode.getIndexColumns().getNodes();
        for (i = 0; i < indexColumns.size(); ++i) {
            IndexColumnName indexColumnName = indexColumns.get(i);
            if (indexColumnName.isExpression()) {
                writer.append("(");
                indexColumnName.getExpressionValue().unParse(writer, context);
                writer.append(") ");
            } else {
                writer.append(indexColumnName.getColumnName().getIdentifier());
            }
            if (indexColumnName.getSortType() != null) {
                writer.writeSpace(1).append(indexColumnName.getSortType().name());
            }
            if (i == indexColumns.size() - 1) continue;
            writer.append(",").writeSpace(1);
        }
        writer.append(")");
        if (sqlNode.getOptions() != null) {
            for (i = 0; i < sqlNode.getOptions().getNodes().size(); ++i) {
                this.parseIndexOption(sqlNode.getOptions().getNodes().get(i), writer, context);
            }
        }
    }

    private void parseIndexOption(IndexOptions options, SqlWriter writer, UnParserContext context) {
        if (options.getLocalPartition() != null) {
            writer.writeSpace(1).append("LOCAL").writeSpace(1);
            IndexPartition indexPartition = options.getLocalPartition();
            if (indexPartition != null) {
                List<PartitionedTable> partitionedTables = indexPartition.getPartitionedTables();
                writer.writeSpace(1).append("(");
                for (int j = 0; j < partitionedTables.size(); ++j) {
                    writer.writeSpace(1).append("PARTITION");
                    if (partitionedTables.get(j).getPartition() != null) {
                        writer.writeSpace(1).append(partitionedTables.get(j).getPartition());
                    }
                    if (partitionedTables.get(j).getTablespace() != null) {
                        writer.writeSpace(1).append("/* TABLESPACE ").append(partitionedTables.get(j).getTablespace()).append(" */");
                    }
                    if (j == partitionedTables.size() - 1) continue;
                    writer.append(",").writeSpace(1);
                }
                writer.append(")");
            }
        }
        if (options.getIndexAttributes() != null) {
            writer.append("/* ");
            writer.append(options.getIndexAttributes().getIndexAttributeValue()).writeSpace(1);
            writer.append("*/");
        }
    }

    private void createIndexNameByArgs(CreateIndex createIndex, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(config, "table.index.rename", "false").equalsIgnoreCase("true")) {
            writer.writeSpace(1);
            writer.append(this.appendIndexNameWithTableName(createIndex));
            return;
        }
        writer.writeSpace(1);
        if (createIndex.getIndexName().getIdentifier().contains(".")) {
            String indexName = "";
            String[] split = createIndex.getIndexName().getIdentifier().split("\\.");
            indexName = split[split.length - 1];
            createIndex.setIndexName(new Identifier(indexName));
        }
        createIndex.getIndexName().unParse(writer, context);
    }

    private String appendIndexNameWithTableName(CreateIndex sqlNode) {
        Identifier tableName = sqlNode.getTableName().getTableName();
        String indexName = sqlNode.getIndexName().getIdentifier();
        String result = "";
        if (indexName.contains(".")) {
            StringBuilder sb = new StringBuilder();
            String[] split = indexName.split("\\.");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(QuoteUtils.addDoubleQuote(split[i])).append(".");
                    continue;
                }
                String s = tableName.getIdentifier() + "_" + QuoteUtils.removeDoubleQuote(indexName);
                sb.append(QuoteUtils.addDoubleQuote(s));
            }
            result = sb.toString();
        } else {
            result = tableName.getIdentifier() + "_" + QuoteUtils.removeDoubleQuote(indexName);
            result = QuoteUtils.addDoubleQuote(result);
        }
        return result.toLowerCase(Locale.ROOT);
    }
}

