/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.CreatePackageBody;
import com.huawei.hwclouds.migration.oracle.model.DeclareSpec;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreatePackageBody.class)
public class CreatePackageBodyUnParser
implements UnParser<CreatePackageBody> {
    @Override
    public void unParse(CreatePackageBody sqlNode, SqlWriter writer, UnParserContext context) {
        for (int i = 0; i < sqlNode.getPackageObjBodySqlNodeList().getNodes().size(); ++i) {
            writer.append("CREATE ");
            if (sqlNode.isExistReplace()) {
                writer.append("OR REPLACE ");
            }
            writer.append(this.getPackagePartType(sqlNode.getPackageObjBodySqlNodeList().getNodes().get(i))).writeSpace(1);
            writer.append(sqlNode.getPackageName()).append(".");
            this.unParsePackageBody(sqlNode.getPackageObjBodySqlNodeList().getNodes().get(i), writer, context);
        }
        context.setNeedDivision(false);
    }

    private String getPackagePartType(DeclareSpec node) {
        if (node.getProcedureBody() != null) {
            return "PROCEDURE";
        }
        if (node.getFunctionBody() != null) {
            return "FUNCTION";
        }
        return null;
    }

    private void unParsePackageBody(DeclareSpec sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getProcedureBody() != null) {
            sqlNode.getProcedureBody().unParse(writer, context);
        } else if (sqlNode.getFunctionBody() != null) {
            sqlNode.getFunctionBody().unParse(writer, context);
        }
    }
}

