/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.CreatePackage;
import com.huawei.hwclouds.migration.oracle.model.DeclareSpec;
import com.huawei.hwclouds.migration.oracle.model.PackageInfo;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreatePackage.class)
public class CreatePackageUnParser
implements UnParser<CreatePackage> {
    @Override
    public void unParse(CreatePackage sqlNode, SqlWriter writer, UnParserContext context) {
        SqlWriter emptyWriter = writer.cloneEmpty();
        this.getVariableMapper(sqlNode, emptyWriter, context);
    }

    private void getVariableMapper(CreatePackage sqlNode, SqlWriter writer, UnParserContext context) {
        PackageInfo packageInfo = new PackageInfo();
        String packageName = sqlNode.getPackageName();
        String[] pkgScheName = packageName.split("\\.");
        if (pkgScheName.length == 2) {
            packageInfo.setPkgName(pkgScheName[0]);
            packageInfo.setSchemaName(pkgScheName[1]);
        } else {
            packageInfo.setSchemaName(pkgScheName[0]);
        }
        packageInfo.setPackageMapper(true);
        context.setPackageInfo(packageInfo);
        List<DeclareSpec> nodes = sqlNode.getPackageObjSpec().getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            nodes.get(i).unParse(writer, context);
        }
        context.getPackageInfo().setPackageMapper(false);
    }
}

