/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.CreateTable;
import com.huawei.hwclouds.migration.oracle.model.RelationalProperty;
import com.huawei.hwclouds.migration.oracle.model.RelationalTable;
import com.huawei.hwclouds.migration.oracle.model.TableConstraint;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateTable.class)
public class CreateTableUnParser
implements UnParser<CreateTable> {
    @Override
    public void unParse(CreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE").writeSpace(1);
        if (sqlNode.isTemp()) {
            writer.append("GLOBAL TEMPORARY").writeSpace(1);
        }
        writer.append("TABLE").writeSpace(1);
        sqlNode.getTableName().unParse(writer, context);
        this.spellColumn(sqlNode, writer, context);
        if (sqlNode.getSelectOnlyStatement() != null) {
            writer.append(" AS ");
            sqlNode.getSelectOnlyStatement().unParse(writer, context);
        }
        if (sqlNode.getRelationalTable() != null) {
            RelationalTable relationalTable = sqlNode.getRelationalTable();
            if (relationalTable.getCommitInfo() != null) {
                writer.append("ON COMMIT PRESERVE ROWS ");
            }
            if (relationalTable.getPhysicalProperties() != null) {
                relationalTable.getPhysicalProperties().unParse(writer, context);
            }
            if (relationalTable.getColumnPropertiesSqlNodeList() != null) {
                for (int i = 0; i < relationalTable.getColumnPropertiesSqlNodeList().getNodes().size(); ++i) {
                    relationalTable.getColumnPropertiesSqlNodeList().getNodes().get(i).unParse(writer, context);
                }
            }
            if (relationalTable.getTablePartitioningClauses() != null) {
                relationalTable.getTablePartitioningClauses().unParse(writer, context);
            }
            if (relationalTable.getParallelClause() != null) {
                writer.append("/* ");
                writer.append(relationalTable.getParallelClause().getParallelClause()).writeSpace(1);
                writer.append(" */ ");
            }
        }
    }

    private void spellColumn(CreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        boolean isComment = ConfigUtil.getConfigValue(config, "table.foreign.key.comment", "false").equalsIgnoreCase("true");
        boolean isForeignKey = false;
        boolean isLoggingProps = false;
        if (sqlNode.getRelationalTable() != null) {
            List<RelationalProperty> nodes = sqlNode.getRelationalTable().getRelationalPropertySqlNodeList().getNodes();
            if (nodes.isEmpty()) {
                return;
            }
            writer.append("(").writeSpace(1);
            for (int i = 0; i < nodes.size(); ++i) {
                if (nodes.get(i).getTableConstraint() != null) {
                    TableConstraint tableConstraint = nodes.get(i).getTableConstraint();
                    String constraintType = tableConstraint.getConstraintType().getIdentifier();
                    isForeignKey = constraintType.toUpperCase(Locale.ROOT).equals("FOREIGN KEY");
                }
                if (nodes.get(i).getSupplementalLoggingProps() != null) {
                    isLoggingProps = true;
                }
                if (!(i == 0 || isForeignKey && isComment || isLoggingProps)) {
                    writer.append(", ");
                }
                nodes.get(i).unParse(writer, context);
            }
            writer.append(")").writeSpace(1);
        }
    }
}

