/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.DataType;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=DataType.class)
public class DataTypeUnParser
implements UnParser<DataType> {
    @Override
    public void unParse(DataType sqlNode, SqlWriter writer, UnParserContext context) {
        this.exchangeDataType(sqlNode, writer);
        if (sqlNode.getPrecision() != null) {
            if (sqlNode.getCharset() != null && sqlNode.getCharset().equals("CHAR")) {
                writer.append("(");
                writer.append(String.valueOf(Integer.parseInt(sqlNode.getPrecision().toString()) * 4));
                writer.append(")");
            } else {
                this.doAppendPrecision(sqlNode, writer);
            }
        }
    }

    private void doAppendPrecision(DataType sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case RAW: {
                break;
            }
            case FLOAT: {
                writer.append("(");
                int precision = Integer.parseInt(sqlNode.getPrecision().toString());
                if (precision > 53) {
                    writer.append("53");
                } else {
                    writer.append(sqlNode.getPrecision().toString());
                }
                writer.append(")");
                break;
            }
            default: {
                writer.append("(");
                writer.append(sqlNode.getPrecision().toString());
                if (sqlNode.getScale() != null) {
                    writer.append(",").append(sqlNode.getScale().toString());
                }
                writer.append(")");
            }
        }
    }

    private void exchangeDataType(DataType sqlNode, SqlWriter writer) {
        switch (sqlNode.getTypeName()) {
            case LONG: {
                writer.append("TEXT");
                break;
            }
            case RAW: 
            case LONG_RAW: {
                writer.append("BYTEA");
                break;
            }
            case DOUBLE_PRECISION: {
                writer.append("DOUBLE PRECISION");
                break;
            }
            case STRING: {
                writer.append("VARCHAR");
                break;
            }
            default: {
                writer.append(sqlNode.getTypeName().getName());
            }
        }
    }
}

