/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.util.ParserRuntimeException;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.DropIndex;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=DropIndex.class)
public class DropIndexUnParser
implements UnParser<DropIndex> {
    @Override
    public void unParse(DropIndex sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(config, "table.index.rename", "false").equalsIgnoreCase("true")) {
            throw new ParserRuntimeException("Drop index is not supported when the param of table.index.rename is true");
        }
        writer.append("DROP INDEX ");
        if (sqlNode.isIfExists()) {
            writer.append("IF EXISTS ");
        }
        writer.append(sqlNode.getIndexName().getIdentifier());
    }
}

