/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.util.ParserRuntimeException;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.ExplainStatement;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=ExplainStatement.class)
public class ExplainStatementUnParser
implements UnParser<ExplainStatement> {
    @Override
    public void unParse(ExplainStatement sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(" EXPLAIN PLAN ");
        if (sqlNode.getStatementId() != null) {
            writer.append("SET STATEMENT_ID = ").append(sqlNode.getStatementId()).writeSpace(1);
        }
        if (sqlNode.getIntoTableName() != null) {
            throw new ParserRuntimeException("Explain plan dose not support intoTableClause in dws ");
        }
        this.dealForDmlStatement(sqlNode, writer, context);
    }

    private void dealForDmlStatement(ExplainStatement sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(" FOR ");
        switch (sqlNode.getDmlStatementType()) {
            case "INSERT": {
                sqlNode.getInsertStatement().unParse(writer, context);
                break;
            }
            case "DELETE": {
                sqlNode.getDeleteStatement().unParse(writer, context);
                break;
            }
            case "UPDATE": {
                sqlNode.getUpdateStatement().unParse(writer, context);
                break;
            }
            case "MERGE": {
                sqlNode.getMergeStatement().unParse(writer, context);
                break;
            }
            case "SELECT": {
                sqlNode.getSelectStatement().unParse(writer, context);
                break;
            }
        }
    }
}

