/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Argument;
import com.huawei.hwclouds.migration.oracle.model.FunctionArgument;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=FunctionArgument.class)
public class FunctionArgumentUnParser
implements UnParser<FunctionArgument> {
    @Override
    public void unParse(FunctionArgument sqlNode, SqlWriter writer, UnParserContext context) {
        List<Argument> argumentList = sqlNode.getArgumentList();
        if (argumentList != null && argumentList.size() > 0) {
            if (sqlNode.getFuncName() != null && sqlNode.getFuncName().trim().equalsIgnoreCase("TO_DATE")) {
                this.toDateArgConvert(sqlNode.getArgumentList(), writer, context);
            } else {
                this.commonArgConvert(sqlNode.getArgumentList(), writer, context);
            }
        }
    }

    private void toDateArgConvert(List<Argument> argumentList, SqlWriter writer, UnParserContext context) {
        for (int i = 0; i < 2; ++i) {
            SqlWriter sqlWriter = writer.cloneEmpty();
            argumentList.get(i).unParse(sqlWriter, context);
            String arg = sqlWriter.toSqlString().getSql();
            if (i == 0) {
                writer.append(arg);
                writer.append(", ");
                continue;
            }
            if (arg.contains("SYYYY")) {
                arg = arg.replace("SYYYY", "YYYY");
            }
            writer.append(arg);
        }
    }

    private void commonArgConvert(List<Argument> argumentList, SqlWriter writer, UnParserContext context) {
        for (int i = 0; i < argumentList.size(); ++i) {
            argumentList.get(i).unParse(writer, context);
            if (i == argumentList.size() - 1) continue;
            writer.append(", ");
        }
    }
}

