/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.FunctionBody;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=FunctionBody.class)
public class FunctionBodyUnParser
implements UnParser<FunctionBody> {
    @Override
    public void unParse(FunctionBody sqlNode, SqlWriter writer, UnParserContext context) {
        int i;
        writer.append(sqlNode.getFunctionName()).writeSpace(1);
        if (sqlNode.getParameterSqlNodeList() != null) {
            writer.append("( ");
            for (i = 0; i < sqlNode.getParameterSqlNodeList().getNodes().size(); ++i) {
                sqlNode.getParameterSqlNodeList().getNodes().get(i).unParse(writer, context);
                if (i == sqlNode.getParameterSqlNodeList().getNodes().size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        }
        writer.append("RETURN ");
        sqlNode.getTypeSpec().unParse(writer, context);
        writer.writeSpace(1);
        if (sqlNode.getFunctionSubOptionClauseSqlNodeList() != null) {
            for (i = 0; i < sqlNode.getFunctionSubOptionClauseSqlNodeList().getNodes().size(); ++i) {
                sqlNode.getFunctionSubOptionClauseSqlNodeList().getNodes().get(i).unParse(writer, context);
            }
        }
        if (sqlNode.getImplementationTypeName() != null) {
            if (sqlNode.isExistSPipelined()) {
                writer.append("PIPELINED ");
            } else if (sqlNode.isExistAggregate()) {
                writer.append("AGGREGATE ");
            }
            writer.append("USING ").append(sqlNode.getImplementationTypeName());
        } else {
            if (sqlNode.isExistFPipelined()) {
                writer.append("PIPELINED ");
            }
            if (sqlNode.isExistDeterministic()) {
                writer.append("DETERMINISTIC ");
            }
            writer.append(sqlNode.getIsOrAs()).writeSpace(1);
            if (sqlNode.isExistDeclare()) {
                writer.append("DECLARE ");
            }
            if (sqlNode.getSeqOfDeclareSpecs() != null) {
                sqlNode.getSeqOfDeclareSpecs().unParse(writer, context);
            }
            if (sqlNode.getBody() != null) {
                context.setNeedDivision(false);
                sqlNode.getBody().unParse(writer, context);
            } else {
                sqlNode.getCallSpec().unParse(writer, context);
            }
        }
    }
}

