/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.AdvancedPackage;
import com.huawei.hwclouds.migration.oracle.model.Argument;
import com.huawei.hwclouds.migration.oracle.model.Constant;
import com.huawei.hwclouds.migration.oracle.model.FunctionArgument;
import com.huawei.hwclouds.migration.oracle.model.FunctionCall;
import com.huawei.hwclouds.migration.oracle.util.GetArgumentUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=FunctionCall.class)
public class FunctionCallUnParser
implements UnParser<FunctionCall> {
    @Override
    public void unParse(FunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        if (!this.needCall(sqlNode.getRoutineName())) {
            if (sqlNode.isExistCall()) {
                writer.append("CALL ");
            }
        } else {
            if (sqlNode.isExistCall() || context.isProcedure() && !context.isException()) {
                writer.append("CALL ");
            }
            if (context.isException()) {
                writer.append("PERFORM ");
            }
        }
        writer.append(sqlNode.getRoutineName()).writeSpace(1);
        this.dealWithFunction(sqlNode);
        if (sqlNode.isExistsBrackets()) {
            writer.append("( ");
            if (sqlNode.getFunctionArgument() != null) {
                sqlNode.getFunctionArgument().unParse(writer, context);
            }
            writer.append(") ");
            if (sqlNode.getKeepClause() != null) {
                sqlNode.getKeepClause().unParse(writer, context);
            }
        }
    }

    private boolean needCall(String routineName) {
        String[] parts = routineName.split("\\.");
        return Arrays.stream(AdvancedPackage.values()).noneMatch(advancedPackage -> advancedPackage.name().equalsIgnoreCase(parts[0]));
    }

    private void dealWithFunction(FunctionCall sqlNode) {
        if (sqlNode.getRoutineName().toLowerCase(Locale.ROOT).contains(".extend") && sqlNode.getFunctionArgument() == null) {
            Constant constant = new Constant();
            constant.setNumeric("1");
            Argument argument = GetArgumentUtil.extracted(constant);
            FunctionArgument functionArgument = new FunctionArgument();
            ArrayList<Argument> argumentList = new ArrayList<Argument>();
            argumentList.add(argument);
            functionArgument.setArgumentList(argumentList);
            sqlNode.setFunctionArgument(functionArgument);
        }
    }
}

