/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Grant;
import com.huawei.hwclouds.migration.oracle.model.GrantDetail;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.util.SqlWriteUtil;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=Grant.class)
public class GrantStatementUnParser
implements UnParser<Grant> {
    @Override
    public void unParse(Grant sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("GRANT").writeSpace(1);
        List<GrantDetail> grantDetails = sqlNode.getGrantDetails();
        for (int i = 0; i < grantDetails.size(); ++i) {
            GrantDetail grantDetail = grantDetails.get(i);
            writer.append(grantDetail.getGrantType().getName()).writeSpace(1);
            SqlNodeList<Identifier> columnNames = grantDetail.getColumnNames();
            if (columnNames == null) continue;
            writer.append("(");
            SqlWriteUtil.appendSqlIdentifier(writer, context, columnNames.getNodes(), false);
            writer.append(")");
        }
        if (sqlNode.getOnName() != null) {
            writer.append(" ON ").writeSpace(1);
            if (sqlNode.getOnType() != null) {
                writer.append(sqlNode.getOnType().getIdentifier()).writeSpace(1);
            }
            SqlWriteUtil.appendSqlIdentifier(writer, context, sqlNode.getOnName(), false);
        }
        writer.writeSpace(1).append("TO").writeSpace(1);
        SqlWriteUtil.appendSqlIdentifier(writer, context, sqlNode.getToName(), false);
        if (sqlNode.isWithGrantOption()) {
            writer.append(" WITH GRANT OPTION");
        }
    }
}

