/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.LobStorageClause;
import com.huawei.hwclouds.migration.oracle.model.LobStorageParameters;
import com.huawei.hwclouds.migration.oracle.model.StorageParameter;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=LobStorageClause.class)
public class LobStorageClauseUnParser
implements UnParser<LobStorageClause> {
    @Override
    public void unParse(LobStorageClause sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("LOB (");
        for (int i = 0; i < sqlNode.getLobItem().size(); ++i) {
            writer.append(sqlNode.getLobItem().get(i));
            if (i == sqlNode.getLobItem().size() - 1) continue;
            writer.append(", ");
        }
        writer.append(") ");
        writer.append("STORE AS ");
        List<StorageParameter> nodes = sqlNode.getStorageParameterSqlNodeList().getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            if (nodes.get(i).getLobStorageParametersSqlNodeList() != null && nodes.get(i).getLobStorageParametersSqlNodeList().getNodes().size() > 0) {
                writer.append("( ");
                for (int j = 0; j < nodes.get(i).getLobStorageParametersSqlNodeList().getNodes().size(); ++j) {
                    this.spellLobStorageParameters(nodes.get(i).getLobStorageParametersSqlNodeList().getNodes().get(j), writer);
                }
                writer.append(") ");
                continue;
            }
            writer.append(nodes.get(i).getParameter()).writeSpace(1);
        }
    }

    private void spellLobStorageParameters(LobStorageParameters lobStorageParameters, SqlWriter writer) {
        if (lobStorageParameters.getTablespaceName() != null) {
            writer.append("TABLESPACE ").append(lobStorageParameters.getTablespaceName());
        } else if (lobStorageParameters.getLobParameters() != null) {
            writer.append(lobStorageParameters.getLobParameters());
        }
        if (lobStorageParameters.getStorageClause() != null) {
            writer.append(lobStorageParameters.getStorageClause());
        }
    }
}

