/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.LockTableElement;
import com.huawei.hwclouds.migration.oracle.model.LockTableStatement;
import com.huawei.hwclouds.migration.oracle.model.SqlLockMode;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=LockTableStatement.class)
public class LockTableStatementUnParser
implements UnParser<LockTableStatement> {
    @Override
    public void unParse(LockTableStatement sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("LOCK TABLE ");
        List<LockTableElement> lockTableElements = sqlNode.getLockTableElementList().getNodes();
        for (int i = 0; i < lockTableElements.size(); ++i) {
            lockTableElements.get(i).unParse(writer, context);
            if (i == lockTableElements.size() - 1) continue;
            writer.append(", ");
        }
        writer.append(" IN ");
        this.dealSqlLockMode(writer, sqlNode.getLockMode());
        writer.append(" MODE ");
        if (sqlNode.getWaitOrNoWait() != null) {
            if (sqlNode.getWaitOrNoWait().equals("NOWAIT")) {
                writer.append("NOWAIT");
            } else {
                writer.append(" /* ").append(" WAIT ");
                sqlNode.getWaitExpression().unParse(writer, context);
                writer.append(" */ ");
            }
        }
    }

    private void dealSqlLockMode(SqlWriter writer, SqlLockMode lockMode) {
        switch (lockMode) {
            case SHARE: {
                writer.append("SHARE");
                break;
            }
            case EXCLUSIVE: {
                writer.append("EXCLUSIVE");
                break;
            }
            case ROWS_HARE: {
                writer.append("ROWS HARE");
                break;
            }
            case SHARE_UPDATE: {
                writer.append("SHARE UPDATE EXCLUSIVE");
                break;
            }
            case ROW_EXCLUSIVE: {
                writer.append("ROW EXCLUSIVE");
                break;
            }
            case SHARE_ROW_EXCLUSIVE: {
                writer.append("SHARE ROW EXCLUSIVE");
                break;
            }
        }
    }
}

