/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.MergeStatement;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=MergeStatement.class)
public class MergeStatementUnParser
implements UnParser<MergeStatement> {
    @Override
    public void unParse(MergeStatement sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(" MERGE INTO ");
        sqlNode.getMergeTableName().unParse(writer, context);
        if (sqlNode.getTableAlias() != null) {
            writer.writeSpace(1).append(sqlNode.getTableAlias());
        }
        writer.append(" USING ");
        sqlNode.getSelectTableView().unParse(writer, context);
        writer.append(" ON ( ");
        sqlNode.getOnCondition().unParse(writer, context);
        writer.append(" ) ");
        if (sqlNode.getFirstType() != null) {
            this.dealMergeUpdateOrInsert(sqlNode, writer, context);
        }
    }

    private void dealMergeUpdateOrInsert(MergeStatement sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getFirstType().equals("UPDATE")) {
            sqlNode.getMergeUpdateClause().unParse(writer, context);
            if (sqlNode.getMergeInsertClause() != null) {
                sqlNode.getMergeInsertClause().unParse(writer, context);
            }
        } else {
            sqlNode.getMergeInsertClause().unParse(writer, context);
            if (sqlNode.getMergeUpdateClause() != null) {
                sqlNode.getMergeUpdateClause().unParse(writer, context);
            }
        }
    }
}

