/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.QueryPartitionClause;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=QueryPartitionClause.class)
public class QueryPartitionClauseUnParser
implements UnParser<QueryPartitionClause> {
    @Override
    public void unParse(QueryPartitionClause sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(" PARTITION BY ");
        if (sqlNode.isBrackets()) {
            writer.append("(");
            if (sqlNode.getSubQuery() != null) {
                sqlNode.getSubQuery().unParse(writer, context);
            }
            this.dealWithExpressionList(sqlNode.getExpressionList(), writer, context);
            writer.append(")");
        } else {
            this.dealWithExpressionList(sqlNode.getExpressionList(), writer, context);
        }
        writer.writeSpace(1);
    }

    private void dealWithExpressionList(SqlNodeList<Expression> expressionList, SqlWriter writer, UnParserContext context) {
        if (expressionList != null) {
            List<Expression> listNodes = expressionList.getNodes();
            for (int i = 0; i < listNodes.size(); ++i) {
                listNodes.get(i).unParse(writer, context);
                if (i == listNodes.size() - 1) continue;
                writer.append(", ");
            }
        }
    }
}

