/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.util.ConvertUtil;
import com.huawei.hwclouds.migration.common.util.QuoteUtils;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.SelectListElement;
import com.huawei.hwclouds.migration.oracle.model.SqlKeyword;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SelectListElement.class)
public class SelectListElementUnParser
implements UnParser<SelectListElement> {
    @Override
    public void unParse(SelectListElement sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getTableName() != null) {
            sqlNode.getTableName().unParse(writer, context);
            writer.append(".*").writeSpace(1);
        }
        if (sqlNode.getExpression() != null) {
            SqlWriter sqlWriter = writer.cloneEmpty();
            sqlNode.getExpression().unParse(sqlWriter, context);
            String column = sqlWriter.toSqlString().getSql().trim();
            if (SqlKeyword.isContains(column.toUpperCase(Locale.ROOT))) {
                writer.append(QuoteUtils.addDoubleQuote(column)).writeSpace(1);
            } else {
                String newColumn = ConvertUtil.columnConvert(column);
                writer.append(newColumn).writeSpace(1);
            }
            if (sqlNode.getExpAlias() != null) {
                if (context.getScalarSubQueryCtx().size() == 0) {
                    if (sqlNode.getExpAlias().isExistAs()) {
                        writer.append("AS ");
                    }
                    if (sqlNode.getExpAlias().getAliasName() != null) {
                        writer.append(sqlNode.getExpAlias().getAliasName()).writeSpace(1);
                    }
                } else {
                    context.getQueryAsName().add(sqlNode.getExpAlias().getAliasName());
                }
            }
        }
        writer.writeSpace(1);
    }
}

