/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.FunctionTrim;
import com.huawei.hwclouds.migration.oracle.model.StringFunction;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=StringFunction.class)
public class StringFunctionUnParser
implements UnParser<StringFunction> {
    @Override
    public void unParse(StringFunction sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getFunctionTrim() != null) {
            FunctionTrim functionTrim = sqlNode.getFunctionTrim();
            writer.append("TRIM ( ");
            if (functionTrim.getTrimOp() != null) {
                writer.append(functionTrim.getTrimOp()).writeSpace(1);
            }
            if (functionTrim.getSourceString() != null) {
                writer.append(functionTrim.getTrimCharacter()).writeSpace(1);
            }
            if (functionTrim.isExistFrom()) {
                writer.append("FROM ");
            }
            functionTrim.getSourceString().unParse(writer, context);
            writer.append(")").writeSpace(1);
        } else if (sqlNode.getStringFunctionName() != null) {
            writer.append(sqlNode.getStringFunctionName()).writeSpace(1);
            writer.append("( ");
            sqlNode.getFunctionArgument().unParse(writer, context);
            if (sqlNode.getStrParameterKeyword() != null) {
                writer.append(sqlNode.getStrParameterKeyword()).writeSpace(1);
            }
            writer.append(")").writeSpace(1);
        }
    }
}

