/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.common.util.ConvertUtil;
import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.Argument;
import com.huawei.hwclouds.migration.oracle.model.Constant;
import com.huawei.hwclouds.migration.oracle.model.FunctionArgument;
import com.huawei.hwclouds.migration.oracle.model.FunctionListAgg;
import com.huawei.hwclouds.migration.oracle.model.ListaggOverflowClause;
import com.huawei.hwclouds.migration.oracle.model.SystemFunction;
import com.huawei.hwclouds.migration.oracle.util.GetArgumentUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.ArrayList;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SystemFunction.class)
public class SystemFunctionUnParser
implements UnParser<SystemFunction> {
    @Override
    public void unParse(SystemFunction sqlNode, SqlWriter writer, UnParserContext context) {
        this.doConvertSpecialFunction(sqlNode);
        if (sqlNode.getFunctionSystimestamp() != null) {
            writer.append(sqlNode.getFunctionSystimestamp()).writeSpace(1);
        } else if (sqlNode.getFunctionDbmsLob() != null) {
            writer.append(sqlNode.getFunctionDbmsLob().getFuncName()).writeSpace(1);
            writer.append("( ");
            sqlNode.getFunctionDbmsLob().getFunctionArgument().unParse(writer, context);
            writer.append(")").writeSpace(1);
        } else if (sqlNode.getFunctionListAgg() != null) {
            FunctionListAgg functionListAgg = sqlNode.getFunctionListAgg();
            writer.append("LISTAGG ( ");
            if (functionListAgg.getQueryType() != null) {
                writer.append(functionListAgg.getQueryType()).writeSpace(1);
            }
            functionListAgg.getFunctionArgument().unParse(writer, context);
            if (functionListAgg.getListaggOverflowClause() != null) {
                ListaggOverflowClause listaggOverflowClause = functionListAgg.getListaggOverflowClause();
                writer.append("ON OVERFLOW ");
                writer.append(listaggOverflowClause.getOverflowKeyword()).writeSpace(1);
                writer.append(listaggOverflowClause.getWithClause()).writeSpace(1);
            }
            writer.append(")").writeSpace(1);
            if (functionListAgg.getOrderByClause() != null) {
                writer.append("WITHIN GROUP ( ");
                functionListAgg.getOrderByClause().unParse(writer, context);
                writer.append(")").writeSpace(1);
            }
            if (functionListAgg.getOverClause() != null) {
                functionListAgg.getOverClause().unParse(writer, context);
            }
        } else if (sqlNode.getFuncName() != null) {
            String funcName = ConvertUtil.functionConvert(sqlNode.getFuncName());
            writer.append(funcName).writeSpace(1);
            writer.append("( ");
            sqlNode.getFunctionArgument().unParse(writer, context);
            writer.append(")").writeSpace(1);
        }
    }

    private void doConvertSpecialFunction(SystemFunction sqlNode) {
        ArrayList<Argument> newArgumentList;
        FunctionArgument functionArgument;
        Argument argument;
        Constant constant;
        if (sqlNode.getFuncName() != null && sqlNode.getFuncName().equalsIgnoreCase("to_date")) {
            FunctionArgument functionArgument2 = sqlNode.getFunctionArgument();
            if (functionArgument2.getArgumentList().size() == 3) {
                functionArgument2.getArgumentList().remove(2);
            }
            sqlNode.setFunctionArgument(functionArgument2);
        }
        if (sqlNode.getFuncName() != null && sqlNode.getFuncName().equalsIgnoreCase("months_between")) {
            constant = new Constant();
            constant.setQuotedString("month");
            argument = GetArgumentUtil.extracted(constant);
            functionArgument = sqlNode.getFunctionArgument();
            functionArgument.setFuncName("TIMESTAMPDIFF");
            newArgumentList = new ArrayList<Argument>();
            newArgumentList.add(argument);
            newArgumentList.add(functionArgument.getArgumentList().get(1));
            newArgumentList.add(functionArgument.getArgumentList().get(0));
            functionArgument.setArgumentList(newArgumentList);
            sqlNode.setFunctionArgument(functionArgument);
            sqlNode.setFuncName("TIMESTAMPDIFF");
        }
        if (sqlNode.getFuncName() != null && sqlNode.getFuncName().equalsIgnoreCase("nvl2")) {
            constant = new Constant();
            constant.setOtherConstant("null");
            argument = GetArgumentUtil.extracted(constant);
            functionArgument = sqlNode.getFunctionArgument();
            functionArgument.setFuncName("DECODE");
            newArgumentList = new ArrayList();
            newArgumentList.add(functionArgument.getArgumentList().get(0));
            newArgumentList.add(argument);
            newArgumentList.add(functionArgument.getArgumentList().get(2));
            newArgumentList.add(functionArgument.getArgumentList().get(1));
            functionArgument.setArgumentList(newArgumentList);
            sqlNode.setFunctionArgument(functionArgument);
            sqlNode.setFuncName("DECODE");
        }
    }
}

