/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.FlashbackQuery;
import com.huawei.hwclouds.migration.oracle.model.TableReference;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=TableReference.class)
public class TableReferenceUnParser
implements UnParser<TableReference> {
    @Override
    public void unParse(TableReference sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getQueryTableExpression() != null) {
            if (sqlNode.isOnly()) {
                writer.append("ONLY (");
                sqlNode.getQueryTableExpression().unParse(writer, context);
                writer.append(")");
            } else {
                sqlNode.getQueryTableExpression().unParse(writer, context);
            }
        }
        if (sqlNode.getViewName() != null) {
            writer.append(sqlNode.getPreViewNameType()).writeSpace(1);
            sqlNode.getViewName().unParse(writer, context);
        }
        if (sqlNode.getFlashbackQuery() != null) {
            FlashbackQuery flashbackQuery = sqlNode.getFlashbackQuery();
            writer.writeSpace(1).append(flashbackQuery.getVersionsOrAs()).writeSpace(1).append(flashbackQuery.getScnOrTimestamp());
            if (flashbackQuery.isMinValues()) {
                writer.append(" MINVALUE");
            } else {
                flashbackQuery.getPreOrAsExpression().unParse(writer, context);
            }
            if (flashbackQuery.isMinValues()) {
                writer.append(" AND MAXVALUE");
            }
            if (flashbackQuery.getSufExpression() != null) {
                flashbackQuery.getSufExpression().unParse(writer, context);
            }
        }
        if (sqlNode.getPivotClause() != null) {
            sqlNode.getPivotClause().unParse(writer, context);
        }
        if (sqlNode.getUnpivotClause() != null) {
            sqlNode.getUnpivotClause().unParse(writer, context);
        }
        if (sqlNode.getTableAlias() != null && context.isNeedAsName()) {
            writer.append(sqlNode.getTableAlias().getIdentifier()).writeSpace(1);
        }
    }
}

