/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.unparser;

import com.huawei.hwclouds.migration.oracle.UnParser;
import com.huawei.hwclouds.migration.oracle.UnParserAnnotation;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.WindowingClause;
import com.huawei.hwclouds.migration.oracle.model.WindowingElement;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=WindowingClause.class)
public class WindowingClauseUnParser
implements UnParser<WindowingClause> {
    @Override
    public void unParse(WindowingClause sqlNode, SqlWriter writer, UnParserContext context) {
        writer.writeSpace(1).append(sqlNode.getWindowingType()).writeSpace(1);
        List<WindowingElement> windowingElements = sqlNode.getWindowingElements().getNodes();
        if (windowingElements.size() == 1) {
            this.dealWithSqlWindowingElement(windowingElements.get(0), writer, context);
        } else if (windowingElements.size() == 2) {
            writer.append("BETWEEN ");
            this.dealWithSqlWindowingElement(windowingElements.get(0), writer, context);
            writer.append("AND ");
            this.dealWithSqlWindowingElement(windowingElements.get(1), writer, context);
        }
    }

    private void dealWithSqlWindowingElement(WindowingElement windowingElement, SqlWriter writer, UnParserContext context) {
        if (windowingElement.getUnboundedPreceding() != null) {
            writer.append(" UNBOUNDED PRECEDING");
        }
        if (windowingElement.getCurrentRow() != null) {
            writer.append(" CURRENT ROW");
        }
        if (windowingElement.getConcatenation() != null) {
            windowingElement.getConcatenation().unParse(writer, context);
            writer.writeSpace(1).append(windowingElement.getConcatenationType());
        }
        writer.writeSpace(1);
    }
}

