/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.util;

import com.huawei.db.migration.interfaces.ISqlString;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;

public class SqlString
implements ISqlString {
    private final String str;
    private SqlDialect dialect;

    public SqlString(SqlDialect dialect, String str) {
        this.dialect = dialect;
        this.str = str;
        assert (str != null);
        assert (dialect != null);
    }

    public String toString() {
        return this.str;
    }

    public String getSql() {
        return this.str;
    }

    public SqlDialect getDialect() {
        return this.dialect;
    }

    public static String handleErrorRes(String res) {
        res = res.replace("| |", "||");
        res = res.replace(" @ ", "@");
        res = res.replace(": =", ":=");
        res = res.replace("/;", "/");
        res = res.replace("< =", "<=");
        res = res.replace("> =", ">=");
        res = res.replace("! =", "!=");
        res = res.replace("= >", "=>");
        return res;
    }

    public static String handleFlagSign(String toString) {
        toString = toString.replace("/ SIGN_DSC_FORMAT_001", "/\n");
        toString = toString.replace("SIGN_DSC_FORMAT_002;", "");
        return toString;
    }

    public static boolean isSqlComment(String sql) {
        String oirStr = sql.trim();
        if (oirStr.startsWith("#")) {
            return true;
        }
        if (oirStr.startsWith("--")) {
            return true;
        }
        if (oirStr.startsWith("*")) {
            return true;
        }
        if (oirStr.startsWith("/*")) {
            return true;
        }
        return oirStr.startsWith("*/");
    }
}

