/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.writer;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.util.SqlString;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;

public class SqlPrettyWriter
implements SqlWriter {
    private StringWriter sw = new StringWriter();
    private SqlDialect dialect;
    private ConvertConfig defaultConfig;
    private Map<String, ConvertConfig> tableConfigs;

    public SqlPrettyWriter(SqlDialect dialect, ConvertConfig defaultConfig, Map<String, ConvertConfig> tableConfigs) {
        this.dialect = dialect;
        this.defaultConfig = defaultConfig;
        this.tableConfigs = tableConfigs;
    }

    @Override
    public SqlWriter append(String sql) {
        if (sql == null || sql.isEmpty()) {
            return this;
        }
        this.sw.append(sql);
        return this;
    }

    @Override
    public SqlWriter append(SqlWriter writer) {
        this.sw.append(writer.toSqlString().getSql());
        return this;
    }

    @Override
    public SqlWriter writeSpace(int size) {
        for (int i = 0; i < size; ++i) {
            this.sw.append(" ");
        }
        return this;
    }

    @Override
    public SqlWriter newLine() {
        this.sw.append(System.lineSeparator());
        return this;
    }

    @Override
    public SqlWriter sqlEnd() {
        this.sw.append(";");
        return this;
    }

    @Override
    public SqlWriter cloneEmpty() {
        return new SqlPrettyWriter(this.dialect, this.defaultConfig, this.tableConfigs);
    }

    @Override
    public SqlDialect getDialect() {
        return this.dialect;
    }

    @Override
    public SqlString toSqlString() {
        return new SqlString(this.dialect, this.sw.toString());
    }

    @Override
    public ConvertConfig getConfig(String tableName) {
        if (tableName == null || tableName.isEmpty()) {
            return this.defaultConfig;
        }
        String formattedTableName = tableName.toUpperCase(Locale.US);
        if (this.tableConfigs.containsKey(formattedTableName)) {
            return this.tableConfigs.get(formattedTableName);
        }
        return this.tableConfigs.containsKey(formattedTableName) ? this.tableConfigs.get(formattedTableName) : this.defaultConfig;
    }
}

