/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive;

import com.huawei.hwclouds.migration.hive.config.ApplicationPropertyLoader;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileHandler {
    private static final Logger logger = LogManager.getLogger(FileHandler.class);
    private int fileNo = 1;

    public Map<String, String> processSQLFiles(String srcFolder, Map<String, String> filesMap) {
        String[] validExt = FileHandler.getValidFileExtension();
        Map<String, String> fileMap = filesMap;
        String src = FilenameUtils.normalize((String)srcFolder);
        if (src != null) {
            File folder = new File(src);
            File[] files = folder.listFiles();
            if (files != null && files.length != 0) {
                for (File file : files) {
                    this.updateMapWithFile(fileMap, file, validExt);
                }
            } else {
                logger.info("No SQL Files in the folder {}", (Object)srcFolder);
            }
        }
        return fileMap;
    }

    public static String[] getValidFileExtension() {
        String extensions = ApplicationPropertyLoader.getStringProperty("fileExtension");
        if ((extensions = extensions.replace(".", "").replace(" ", "")).matches("[a-zA-Z0-9-_,]+")) {
            if (!extensions.isEmpty()) {
                return extensions.split("\\s*,\\s*");
            }
        } else {
            logger.error("Invalid configurable file extensions, default to SQL");
        }
        return new String[]{"sql"};
    }

    private void updateMapWithFile(Map<String, String> fileMap, File file, String[] validExt) {
        if (file.isDirectory()) {
            this.processSQLFiles(file.toString(), fileMap);
        } else if (file.isFile() && this.isValidFile(file.getName().toLowerCase(Locale.ROOT), validExt)) {
            try {
                fileMap.put("File" + this.fileNo, file.getCanonicalPath());
            }
            catch (IOException e) {
                logger.error("Error occured while getting path of the file:" + file.toString());
            }
            ++this.fileNo;
        }
    }

    private boolean isValidFile(String fileName, String[] validExt) {
        for (String ext : validExt) {
            if (!fileName.endsWith("." + ext)) continue;
            return true;
        }
        return false;
    }
}

