/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive;

import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.DatabaseConvertor;
import com.huawei.hwclouds.migration.hive.DWSConfig;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.config.ConvertConfig;
import com.huawei.hwclouds.migration.hive.nodes.SqlRoot;
import com.huawei.hwclouds.migration.hive.parser.HiveEntranceParser;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.util.SqlString;
import com.huawei.hwclouds.migration.hive.writer.SqlPrettyWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class HiveConvertor
implements DatabaseConvertor {
    private SqlRoot root = null;
    private SqlDialect dialect = SqlDialect.DWS;
    private DWSConfig defaultConfig;
    private Map<String, ConvertConfig> tableConfigs = new HashMap<String, ConvertConfig>();

    public HiveConvertor(Map<String, DWSConfig> configs) {
        this(null, configs);
    }

    public HiveConvertor(DWSConfig dwsConfig, Map<String, DWSConfig> configs) {
        this.defaultConfig = dwsConfig == null ? DWSConfig.buildConfig() : dwsConfig;
        Map<String, DWSConfig> tableDefaultConfigs = DWSConfig.loadTableConfigs();
        for (Map.Entry<String, DWSConfig> et : tableDefaultConfigs.entrySet()) {
            this.tableConfigs.put(et.getKey().toUpperCase(Locale.US), et.getValue().clone().merge(this.defaultConfig));
        }
        if (configs != null) {
            for (Map.Entry<String, DWSConfig> et : configs.entrySet()) {
                this.tableConfigs.put(et.getKey().toUpperCase(Locale.US), et.getValue().clone().merge(this.defaultConfig));
            }
        }
    }

    public void parse(String sql) throws ParserException {
        HiveEntranceParser parser = new HiveEntranceParser();
        SqlRoot sqlNode = parser.parse(sql);
        if (this.root == null) {
            this.root = sqlNode;
        } else {
            this.root.addNode(sqlNode);
        }
    }

    public SqlString convert() throws ParserException {
        if (this.root == null) {
            throw new ParserException("No parse sql defined.");
        }
        UnParserContext context = new UnParserContext();
        SqlPrettyWriter writer = new SqlPrettyWriter(this.dialect, this.defaultConfig, this.tableConfigs);
        this.root.unParse(writer, context);
        return writer.toSqlString();
    }

    public void reset() {
        this.root = new SqlRoot();
    }
}

