/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.config;

import com.huawei.hwclouds.migration.hive.util.ConvertRuntimeException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConvertConfig
implements Cloneable {
    private static final Logger LOGGER = LogManager.getLogger(ConvertConfig.class);
    public static final String DEFAULT_CONVERTOR_PROPERTIES = "default-convertor.properties";
    private static Path configPath;
    private Properties properties;

    public ConvertConfig() {
        this(new Properties());
    }

    public ConvertConfig(Properties properties) {
        this.properties = properties == null ? new Properties() : properties;
    }

    public ConvertConfig merge(ConvertConfig config) {
        if (config != null) {
            for (Map.Entry<Object, Object> et : config.properties.entrySet()) {
                if (this.properties.containsKey(et.getKey())) continue;
                this.properties.put(et.getKey(), et.getValue());
            }
        }
        return this;
    }

    public String getStringValue(String key) {
        return this.properties.getProperty(key);
    }

    public String getStringValue(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public void setStringValue(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public ConvertConfig clone() {
        try {
            ConvertConfig config = (ConvertConfig)super.clone();
            config.merge(this);
            return config;
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("failed to convert config file " + e);
            throw new ConvertRuntimeException("failed to convert config file ", e);
        }
    }

    public static ConvertConfig buildConfig() {
        return ConvertConfig.loadConfig(DEFAULT_CONVERTOR_PROPERTIES);
    }

    protected static ConvertConfig loadConfig(String configFile) {
        if (System.getProperty("config.dir") != null) {
            configPath = Paths.get(System.getProperty("config.dir"), new String[0]).toAbsolutePath().normalize();
            configFile = configPath + File.separator + configFile;
        }
        Properties propertiesIn = ConvertConfig.readProperties(configFile);
        Properties np = new Properties();
        for (Map.Entry<Object, Object> et : propertiesIn.entrySet()) {
            String key = (String)et.getKey();
            String skey = key.toLowerCase(Locale.US);
            if (!skey.startsWith("table.") || skey.startsWith("table.table.")) continue;
            np.setProperty(key, (String)et.getValue());
        }
        return new ConvertConfig(np);
    }

    private static Properties readProperties(String configFile) {
        InputStream stream = null;
        BufferedInputStream buffer = null;
        try {
            ClassLoader classLoader = ConvertConfig.class.getClassLoader();
            if (classLoader == null) {
                LOGGER.error("could not find " + configFile);
                throw new ConvertRuntimeException("could not find " + configFile);
            }
            stream = configFile.contains(File.separator) ? new FileInputStream(configFile) : classLoader.getResourceAsStream(configFile);
            if (stream == null) {
                LOGGER.error("could not find " + configFile);
                throw new ConvertRuntimeException("could not find " + configFile);
            }
            buffer = new BufferedInputStream(stream);
            Properties propertiesIn = new Properties();
            propertiesIn.load(buffer);
            Properties properties = propertiesIn;
            return properties;
        }
        catch (RuntimeException re) {
            LOGGER.error("failed to parse config file " + configFile);
            throw new ConvertRuntimeException("failed to parse config file " + configFile, re);
        }
        catch (Exception e) {
            LOGGER.error("failed to parse config file " + configFile);
            throw new ConvertRuntimeException("failed to parse config file " + configFile, e);
        }
        finally {
            try {
                if (buffer != null) {
                    buffer.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to close statement.");
            }
        }
    }

    protected static Map<String, ConvertConfig> loadTableConfigs(String configFile) {
        HashMap<String, ConvertConfig> tableConfigs = new HashMap<String, ConvertConfig>();
        if (System.getProperty("config.dir") != null) {
            configPath = Paths.get(System.getProperty("config.dir"), new String[0]).toAbsolutePath().normalize();
            configFile = configPath + File.separator + configFile;
        }
        Properties propertiesIn = ConvertConfig.readProperties(configFile);
        HashMap<String, Properties> pmap = new HashMap<String, Properties>();
        for (Map.Entry<Object, Object> et2 : propertiesIn.entrySet()) {
            String key = (String)et2.getKey();
            String skey = key.toLowerCase(Locale.US);
            if (!key.startsWith("table.table.") && key.startsWith("table.")) continue;
            String tableName = skey.substring(0, skey.indexOf("."));
            String config = skey.substring(tableName.length() + 1);
            String upTableName = tableName.toUpperCase(Locale.US);
            if (!pmap.containsKey(upTableName)) {
                pmap.put(upTableName, new Properties());
            }
            ((Properties)pmap.get(upTableName)).setProperty(config, (String)et2.getValue());
        }
        pmap.entrySet().stream().forEach(et -> tableConfigs.put((String)et.getKey(), new ConvertConfig((Properties)et.getValue())));
        return tableConfigs;
    }

    protected Properties getConfigMap() {
        return this.properties;
    }
}

