/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.config;

import com.huawei.hwclouds.migration.hive.util.ParserRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyLoader {
    private static final Logger LOGGER = LogManager.getLogger(PropertyLoader.class);

    public static Map<String, String> loadPropertyFile(String proFileName) {
        Map<String, String> propertyMap;
        block13: {
            StringBuffer sb = new StringBuffer();
            propertyMap = null;
            String configDir = FilenameUtils.normalize((String)System.getProperty("config.dir"));
            if (configDir == null || !new File(configDir).exists()) {
                throw new ParserRuntimeException("Error while loading the property files from config directory.");
            }
            PropertyLoader.getConfigFolder(proFileName, sb, configDir);
            String propertyFileName = sb.toString();
            Properties objProp = new Properties();
            InputStream inputStream = null;
            try {
                propertyFileName = FilenameUtils.normalize((String)propertyFileName);
                if (propertyFileName == null) {
                    throw new ParserRuntimeException("Error while loading the property file.");
                }
                File propFile = new File(propertyFileName);
                Path path = Paths.get(propFile.getCanonicalPath(), new String[0]);
                if (propFile.exists()) {
                    inputStream = new FileInputStream(path.toFile());
                    objProp.load(inputStream);
                    propertyMap = PropertyLoader.doGetPropsMap(objProp);
                    LOGGER.info("Successfully loaded Property file : {}", (Object)propertyFileName);
                    break block13;
                }
                throw new ParserRuntimeException("Error while loading the property file.");
            }
            catch (IOException e) {
                LOGGER.error("Error while loading the property file.");
                throw new ParserRuntimeException("Error while loading the property file.");
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Error while loading the property file.");
                    }
                }
            }
        }
        return propertyMap;
    }

    private static void getConfigFolder(String proFileName, StringBuffer sb, String configDir) {
        File configFolder = new File(configDir);
        if (!configFolder.isDirectory() || !configFolder.canRead()) {
            throw new ParserRuntimeException("Error while loading the property files from config directory, directory is not readable.");
        }
        sb.append(configFolder.toString()).append("/").append(proFileName).append(".").append("properties");
    }

    private static Map<String, String> doGetPropsMap(Properties objProp) {
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>(10);
        String key = null;
        Enumeration<Object> e = objProp.keys();
        while (e.hasMoreElements()) {
            Object objElement = e.nextElement();
            if (!(objElement instanceof String)) continue;
            key = (String)objElement;
            propertyMap.put(key, objProp.getProperty(key).trim());
        }
        return propertyMap;
    }

    private static StringBuffer getPropertyFileName(String proFileName) {
        StringBuffer fileName = new StringBuffer();
        String configDir = FilenameUtils.normalize((String)System.getProperty("config.dir"));
        if (configDir == null) {
            throw new ParserRuntimeException("Error while loading the property files from config directory.");
        }
        File configFolder = new File(configDir);
        if (!configFolder.isDirectory()) {
            throw new ParserRuntimeException("Error while loading the property files from config directory, directory is not readable.");
        }
        fileName.append(configFolder.toString()).append("/").append(proFileName).append(".").append("properties");
        return fileName;
    }
}

