/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.config;

import com.huawei.hwclouds.migration.hive.writer.SqlWriter;
import java.util.Locale;

public class SqlDataType {
    public static void writeAppendDataType(String typeName, SqlWriter writer) {
        typeName = typeName.trim();
        int doConvertCnt = 0;
        doConvertCnt += SqlDataType.writeAppendNumericType(typeName, writer);
        doConvertCnt += SqlDataType.writeAppendCharacterType(typeName, writer);
        if ((doConvertCnt += SqlDataType.writeAppendDateType(typeName, writer)) == 0) {
            SqlDataType.writerAppendOtherType(typeName, writer);
        }
        writer.writeSpace(1);
    }

    private static void writerAppendOtherType(String typeName, SqlWriter writer) {
        writer.append(typeName);
    }

    private static int writeAppendNumericType(String typeName, SqlWriter writer) {
        switch (typeName.toLowerCase(Locale.ROOT)) {
            case "int": {
                writer.append("INTEGER");
                break;
            }
            case "bigint": {
                writer.append("BIGINT");
                break;
            }
            case "float": {
                writer.append("FLOAT4");
                break;
            }
            case "double": {
                writer.append("DOUBLE PRECISION");
                break;
            }
            default: {
                return 0;
            }
        }
        return 1;
    }

    private static int writeAppendCharacterType(String typeName, SqlWriter writer) {
        switch (typeName.toLowerCase(Locale.ROOT)) {
            case "string": 
            case "char": 
            case "varchar": {
                writer.append("VARCHAR");
                break;
            }
            default: {
                return 0;
            }
        }
        return 1;
    }

    private static int writeAppendDateType(String typeName, SqlWriter writer) {
        switch (typeName.toLowerCase(Locale.ROOT)) {
            case "date": {
                writer.append("DATE");
                break;
            }
            case "datetime": 
            case "timestamp": {
                writer.append("TIMESTAMP");
                break;
            }
            default: {
                return 0;
            }
        }
        return 1;
    }
}

