/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.unparser;

import com.huawei.hwclouds.migration.hive.UnParser;
import com.huawei.hwclouds.migration.hive.UnParserAnnotation;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.config.SqlDataType;
import com.huawei.hwclouds.migration.hive.nodes.AtomExpression;
import com.huawei.hwclouds.migration.hive.nodes.IntervalExpression;
import com.huawei.hwclouds.migration.hive.nodes.LateralView;
import com.huawei.hwclouds.migration.hive.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.hive.nodes.WhenThenExpressionList;
import com.huawei.hwclouds.migration.hive.util.QuoteUtils;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.writer.SqlWriter;
import java.util.Map;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=AtomExpression.class)
public class AtomExpressionUnParser
implements UnParser<AtomExpression> {
    @Override
    public void unParse(AtomExpression sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getConstant() != null) {
            sqlNode.getConstant().unParse(writer, context);
        } else if (sqlNode.getIntervalExpression() != null) {
            IntervalExpression intervalExpression = sqlNode.getIntervalExpression();
            if (intervalExpression.isExistsInterval()) {
                writer.append("INTERVAL ");
                if (intervalExpression.getExpression() != null) {
                    writer.append("( ");
                    intervalExpression.getExpression().unParse(writer, context);
                    writer.append(") ");
                } else {
                    writer.append(intervalExpression.getIntervalValue()).writeSpace(1);
                }
            } else {
                writer.append("( ");
                writer.append(intervalExpression.getIntervalValue()).writeSpace(1);
                writer.append(") ");
            }
            writer.append(intervalExpression.getIntervalQualifiers()).writeSpace(1);
        } else if (sqlNode.getCastExpression() != null) {
            writer.append("CAST (");
            sqlNode.getCastExpression().getExpression().unParse(writer, context);
            writer.append("AS ");
            SqlDataType.writeAppendDataType(sqlNode.getCastExpression().getPrimitiveType().getPrimitiveType().getTypeName(), writer);
            if (sqlNode.getCastExpression().getFmt() != null) {
                writer.append("FORMAT ").append(sqlNode.getCastExpression().getFmt()).writeSpace(1);
            }
            writer.append(") ");
        } else if (sqlNode.getExtractExpression() != null) {
            writer.append("EXTRACT ( ");
            writer.append(sqlNode.getExtractExpression().getTimeQualifiers()).writeSpace(1).append("FROM ");
            sqlNode.getExtractExpression().getExpression().unParse(writer, context);
            writer.append(") ");
        } else if (sqlNode.getFloorExpression() != null) {
            writer.append("FLOOR ( ");
            sqlNode.getFloorExpression().getExpression().unParse(writer, context);
            if (sqlNode.getFloorExpression().getFloorDateQualifiers() != null) {
                writer.append(sqlNode.getFloorExpression().getFloorDateQualifiers()).writeSpace(1);
            }
            writer.append(") ");
        } else if (sqlNode.getCaseExpression() != null) {
            writer.append("CASE ");
            sqlNode.getCaseExpression().getCaseExpression().unParse(writer, context);
            SqlNodeList<WhenThenExpressionList> whenThenExpressionListSqlNodeList = sqlNode.getCaseExpression().getWhenThenExpressionListSqlNodeList();
            for (int i = 0; i < whenThenExpressionListSqlNodeList.getNodes().size(); ++i) {
                writer.append("WHEN ");
                whenThenExpressionListSqlNodeList.getNodes().get(i).getWhenExpression().unParse(writer, context);
                writer.append("THEN ");
                whenThenExpressionListSqlNodeList.getNodes().get(i).getThenExpression().unParse(writer, context);
            }
            if (sqlNode.getCaseExpression().getElseExpression() != null) {
                writer.append("ELSE ");
                sqlNode.getCaseExpression().getElseExpression().unParse(writer, context);
            }
            writer.append("END ");
        } else if (sqlNode.getWhenExpression() != null) {
            writer.append("CASE ");
            SqlNodeList<WhenThenExpressionList> whenThenExpressionListSqlNodeList = sqlNode.getWhenExpression().getWhenThenExpressionListSqlNodeList();
            for (int i = 0; i < whenThenExpressionListSqlNodeList.getNodes().size(); ++i) {
                writer.append("WHEN ");
                whenThenExpressionListSqlNodeList.getNodes().get(i).getWhenExpression().unParse(writer, context);
                writer.append("THEN ");
                whenThenExpressionListSqlNodeList.getNodes().get(i).getThenExpression().unParse(writer, context);
            }
            if (sqlNode.getWhenExpression().getElseExpression() != null) {
                writer.append("ELSE ");
                sqlNode.getWhenExpression().getElseExpression().unParse(writer, context);
            }
            writer.append("END ");
        } else if (sqlNode.getSubQueryExpression() != null) {
            writer.append("( ");
            sqlNode.getSubQueryExpression().unParse(writer, context);
            writer.append(") ");
        } else if (sqlNode.getFunction() != null) {
            sqlNode.getFunction().unParse(writer, context);
        } else if (sqlNode.getTableOrColumn() != null) {
            if (!this.ColumnToLateralView(sqlNode.getTableOrColumn(), context.getLateralRes(), writer, context)) {
                writer.append(sqlNode.getTableOrColumn()).writeSpace(1);
            }
        } else if (sqlNode.getExpressionsNotInParenthesis() != null) {
            writer.append("( ");
            sqlNode.getExpressionsNotInParenthesis().unParse(writer, context);
            writer.append(") ");
        } else if (sqlNode.getType() != null) {
            sqlNode.getType().unParse(writer, context);
        }
    }

    private boolean ColumnToLateralView(String tableOrColumn, Map<String, LateralView> lateralRes, SqlWriter writer, UnParserContext context) {
        if (lateralRes != null) {
            for (String key : lateralRes.keySet()) {
                if (!QuoteUtils.removeAllQuote(key).equalsIgnoreCase(QuoteUtils.removeAllQuote(tableOrColumn))) continue;
                lateralRes.get(key).setLateralViewInColumn(true);
                lateralRes.get(key).unParse(writer, context);
                return true;
            }
        }
        return false;
    }
}

