/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.unparser;

import com.huawei.hwclouds.migration.hive.UnParser;
import com.huawei.hwclouds.migration.hive.UnParserAnnotation;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.nodes.AtomSelectStatement;
import com.huawei.hwclouds.migration.hive.nodes.LateralView;
import com.huawei.hwclouds.migration.hive.nodes.PartitionVal;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.writer.SqlWriter;
import java.util.HashMap;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=AtomSelectStatement.class)
public class AtomSelectStatementUnParser
implements UnParser<AtomSelectStatement> {
    @Override
    public void unParse(AtomSelectStatement sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getSelectClause() != null) {
            if (sqlNode.getFromClause() != null) {
                this.getLateralView(sqlNode, writer, context);
            }
            if (sqlNode.isContainInsertClause()) {
                sqlNode.getSelectClause().setContainInsertClause(true);
            }
            sqlNode.getSelectClause().unParse(writer, context);
            if (sqlNode.getFromClause() != null) {
                sqlNode.getFromClause().unParse(writer, context);
            }
            if (sqlNode.getWhereClause() != null) {
                writer.append("WHERE ");
                sqlNode.getWhereClause().unParse(writer, context);
            } else if (sqlNode.isContainInsertClause() && sqlNode.getPartitionType() != null && sqlNode.getPartitionType().getValue().equalsIgnoreCase("DYNAMIC_STATIC_PARTITION")) {
                writer.append("WHERE ");
                if (sqlNode.getWhereClause() != null) {
                    sqlNode.getWhereClause().unParse(writer, context);
                }
                List<PartitionVal> nodes = sqlNode.getPartitionValSqlNodeList().getNodes();
                for (int i = 0; i < nodes.size(); ++i) {
                    if (nodes.get(i).getConstant() != null) {
                        writer.append(nodes.get(i).getId()).append(" = ").append(nodes.get(i).getConstant().getConstantValue());
                    }
                    if (i == nodes.size() - 1) continue;
                    writer.append("AND ");
                }
            }
            if (sqlNode.getGroupByClause() != null) {
                sqlNode.getGroupByClause().unParse(writer, context);
            }
            if (sqlNode.getHavingClause() != null) {
                writer.append("HAVING ");
                sqlNode.getHavingClause().unParse(writer, context);
            }
            if (sqlNode.getWindowClause() != null) {
                sqlNode.getWindowClause().unParse(writer, context);
            }
            if (sqlNode.getQualifyClause() != null) {
                writer.append("QUALIFY ");
                sqlNode.getQualifyClause().unParse(writer, context);
            }
        } else if (sqlNode.getSelectStatement() != null) {
            writer.append("( ");
            sqlNode.getSelectStatement().unParse(writer, context);
            writer.append(") ");
        }
    }

    private void getLateralView(AtomSelectStatement sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getFromClause().getJoinSource() != null && sqlNode.getFromClause().getJoinSource().getAtomJoinSource().getLateralViewSqlNodeList() != null) {
            List<LateralView> nodes = sqlNode.getFromClause().getJoinSource().getAtomJoinSource().getLateralViewSqlNodeList().getNodes();
            HashMap<String, LateralView> lateralViewMap = new HashMap<String, LateralView>();
            for (int i = 0; i < nodes.size(); ++i) {
                if (nodes.get(i).getIdList() == null || nodes.get(i).getIdList().size() != 1) continue;
                lateralViewMap.put(nodes.get(i).getIdList().get(0), nodes.get(i));
            }
            context.setLateralRes(lateralViewMap);
        }
    }
}

