/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.unparser;

import com.huawei.hwclouds.migration.hive.UnParser;
import com.huawei.hwclouds.migration.hive.UnParserAnnotation;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.config.ConvertConfig;
import com.huawei.hwclouds.migration.hive.nodes.AtomExpression;
import com.huawei.hwclouds.migration.hive.nodes.AtomExpressionAlias;
import com.huawei.hwclouds.migration.hive.nodes.Constant;
import com.huawei.hwclouds.migration.hive.nodes.Expression;
import com.huawei.hwclouds.migration.hive.nodes.Function;
import com.huawei.hwclouds.migration.hive.nodes.Parameter;
import com.huawei.hwclouds.migration.hive.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.hive.util.ConfigUtil;
import com.huawei.hwclouds.migration.hive.util.QuoteUtils;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.writer.SqlWriter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=Function.class)
public class FunctionUnParser
implements UnParser<Function> {
    private String numRegex = "\\d+";

    @Override
    public void unParse(Function sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(config, "table.function.current_date", null).equalsIgnoreCase("true")) {
            this.convertCurrentDate(sqlNode, writer);
            return;
        }
        if ((sqlNode = this.convertFunc(sqlNode, config)).getArrayContainsParameter() != null) {
            sqlNode.getArrayContainsParameter().unParse(writer, context);
            if (sqlNode.isNot()) {
                writer.append("<> ");
            } else {
                writer.append("= ");
            }
        }
        writer.append(sqlNode.getFunctionName());
        writer.append("( ");
        if (sqlNode.isStar()) {
            writer.append("* ");
        } else {
            if (sqlNode.getDistinct() != null) {
                writer.append(sqlNode.getDistinct()).writeSpace(1);
            }
            if (sqlNode.getOldFuncName() != null && sqlNode.getOldFuncName().equalsIgnoreCase("COLLECT_SET")) {
                writer.append("DISTINCT ");
            }
            if (sqlNode.getParameterSqlNodeList() != null) {
                List<Parameter> nodes = sqlNode.getParameterSqlNodeList().getNodes();
                for (int i = 0; i < nodes.size(); ++i) {
                    nodes.get(i).unParse(writer, context);
                    if (i == nodes.size() - 1) continue;
                    writer.append(", ");
                }
            }
        }
        if (sqlNode.getOrderByClause() != null) {
            writer.append(") ");
            if (sqlNode.getFuncExtra() != null) {
                writer.append(sqlNode.getFuncExtra()).writeSpace(1);
            }
            if (sqlNode.getArrayNum() != null) {
                writer.append("[").append(sqlNode.getArrayNum()).append("] ");
            }
            writer.append("WITHIN GROUP ( ");
            sqlNode.getOrderByClause().unParse(writer, context);
            writer.append(") ");
        } else if (sqlNode.getWindowSpecification() != null) {
            if (sqlNode.isLRparen()) {
                writer.append(") ");
                if (sqlNode.getFuncExtra() != null) {
                    writer.append(sqlNode.getFuncExtra()).writeSpace(1);
                }
            }
            if (sqlNode.getArrayNum() != null) {
                writer.append("[").append(sqlNode.getArrayNum()).append("] ");
            }
            if (sqlNode.getNullTreatment() != null) {
                writer.append(sqlNode.getNullTreatment()).writeSpace(1);
            }
            if (sqlNode.isRRparen()) {
                writer.append(") ");
                if (sqlNode.getFuncExtra() != null) {
                    writer.append(sqlNode.getFuncExtra()).writeSpace(1);
                }
            }
            writer.append("OVER ");
            sqlNode.getWindowSpecification().unParse(writer, context);
        } else {
            writer.append(") ");
            if (sqlNode.getRegexpExtractParameter() != null) {
                writer.append("[");
                sqlNode.getRegexpExtractParameter().unParse(writer, context);
                writer.append("]");
            }
            if (sqlNode.getFuncExtra() != null) {
                writer.append(sqlNode.getFuncExtra()).writeSpace(1);
            }
            if (sqlNode.getArrayNum() != null) {
                writer.append("[").append(sqlNode.getArrayNum()).append("] ");
            }
        }
    }

    private void convertCurrentDate(Function sqlNode, SqlWriter writer) {
        writer.append("CURRENT_DATE ");
        if (sqlNode.getFunctionName().equalsIgnoreCase("subdate")) {
            writer.append("- ");
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("date_add")) {
            writer.append("+");
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("add_month")) {
            this.convertAddMonth(sqlNode, writer);
            return;
        }
        this.getConstantValue(sqlNode, writer);
    }

    private void convertAddMonth(Function sqlNode, SqlWriter writer) {
        if (sqlNode.getParameterSqlNodeList() != null) {
            List<Parameter> nodes = sqlNode.getParameterSqlNodeList().getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                if (nodes.get(i).getExpression().getPrecedenceExpressionAlias() != null) {
                    writer.append(nodes.get(i).getExpression().getPrecedenceExpressionAlias().getPrecedenceUnaryOperator().get(0)).writeSpace(1);
                    writer.append("INTERVAL ");
                    writer.append("'");
                    writer.append(nodes.get(i).getExpression().getPrecedenceExpressionAlias().getPrecedenceFieldExpression().getAtomExpression().getConstant().getConstantValue());
                    writer.append(" months'").writeSpace(1);
                    break;
                }
                if (i != nodes.size() - 1) continue;
                writer.append("+ ");
                writer.append("INTERVAL ");
                writer.append("'");
                this.getConstantValue(sqlNode, writer);
                writer.append(" months'").writeSpace(1);
            }
        }
    }

    private void getConstantValue(Function sqlNode, SqlWriter writer) {
        if (sqlNode.getParameterSqlNodeList() != null) {
            List<Parameter> nodes = sqlNode.getParameterSqlNodeList().getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                if (nodes.get(i).getExpression().getAtomExpressionAlias().getAtomExpression().getConstant() == null) continue;
                writer.append(nodes.get(i).getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().getConstantValue());
            }
        }
    }

    private Function convertFunc(Function sqlNode, ConvertConfig config) {
        String constantValue;
        AtomExpressionAlias atomExpressionAlias;
        Parameter parameter;
        Expression expression;
        Parameter parameter2;
        Function function;
        Function timeFunction = this.convertTimeFunc(sqlNode, config);
        if (timeFunction != null) {
            return timeFunction;
        }
        this.convertRegexpFunc(sqlNode);
        if (sqlNode.getFunctionName().equalsIgnoreCase("explode")) {
            sqlNode.setFunctionName("unnest");
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("get_json_object")) {
            sqlNode.setFunctionName("json_object_field");
            sqlNode.getParameterSqlNodeList().getNodes().get(0).setParameterExtra("::json");
            if (sqlNode.getParameterSqlNodeList().getNodes().get(1).getExpression() != null && sqlNode.getParameterSqlNodeList().getNodes().get(1).getExpression().getAtomExpressionAlias() != null) {
                String value = sqlNode.getParameterSqlNodeList().getNodes().get(1).getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().getConstantValue();
                value = value.replace("$.", "");
                sqlNode.getParameterSqlNodeList().getNodes().get(1).getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().setConstantValue(value);
            }
            sqlNode.setFuncExtra("::varchar");
        }
        if (sqlNode.getFunctionName().equals("nvl2")) {
            sqlNode.setFunctionName("NVL");
            function = new Function();
            function.setFunctionName("NVL");
            Parameter parameter1 = sqlNode.getParameterSqlNodeList().getNodes().get(0);
            Parameter parameter22 = sqlNode.getParameterSqlNodeList().getNodes().get(1);
            SqlNodeList<Parameter> parameterSqlNodeList = new SqlNodeList<Parameter>();
            parameterSqlNodeList.addNode(parameter1);
            parameterSqlNodeList.addNode(parameter22);
            function.setParameterSqlNodeList(parameterSqlNodeList);
            parameter2 = new Parameter();
            Expression expression2 = new Expression();
            AtomExpressionAlias atomExpressionAlias2 = new AtomExpressionAlias();
            AtomExpression atomExpression = new AtomExpression();
            atomExpression.setFunction(function);
            atomExpressionAlias2.setAtomExpression(atomExpression);
            expression2.setAtomExpressionAlias(atomExpressionAlias2);
            parameter2.setExpression(expression2);
            sqlNode.getParameterSqlNodeList().getNodes().set(0, parameter2);
            sqlNode.getParameterSqlNodeList().getNodes().set(1, sqlNode.getParameterSqlNodeList().getNodes().get(2));
            sqlNode.getParameterSqlNodeList().getNodes().remove(2);
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("pmod")) {
            sqlNode.setFunctionName("MOD");
            function = new Function();
            function.setFunctionName("ABS");
            SqlNodeList<Parameter> parameterSqlNodeList = new SqlNodeList<Parameter>();
            Parameter parameter3 = new Parameter();
            expression = new Expression();
            AtomExpressionAlias atomExpressionAlias3 = new AtomExpressionAlias();
            AtomExpression atomExpression = new AtomExpression();
            atomExpression.setFunction(sqlNode);
            atomExpressionAlias3.setAtomExpression(atomExpression);
            expression.setAtomExpressionAlias(atomExpressionAlias3);
            parameter3.setExpression(expression);
            parameterSqlNodeList.addNode(parameter3);
            function.setParameterSqlNodeList(parameterSqlNodeList);
            return function;
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("split")) {
            if (sqlNode.getArrayNum() != null) {
                sqlNode.setArrayNum(String.valueOf(Integer.parseInt(sqlNode.getArrayNum()) + 1));
            }
            this.dealWithDoubleQuoteInParam(sqlNode.getParameterSqlNodeList());
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("COLLECT_SET")) {
            sqlNode.setOldFuncName("COLLECT_SET");
            sqlNode.setFunctionName("ARRAY_AGG");
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("COLLECT_LIST")) {
            sqlNode.setFunctionName("ARRAY_AGG");
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("format_number")) {
            sqlNode.setFunctionName("TO_CHAR");
            parameter = sqlNode.getParameterSqlNodeList().getNodes().get(1);
            if (parameter != null) {
                Constant constant = parameter.getExpression().getAtomExpressionAlias().getAtomExpression().getConstant();
                int value = Integer.parseInt(constant.getConstantValue());
                String toCharValue = "'999,999,990.";
                for (int i = 0; i < value; ++i) {
                    toCharValue = toCharValue + "0";
                }
                toCharValue = toCharValue + "'";
                constant.setConstantValue(toCharValue);
            }
        }
        if ("size".equalsIgnoreCase(sqlNode.getFunctionName())) {
            sqlNode.setFunctionName("ARRAY_LENGTH");
            Constant constant = new Constant();
            constant.setConstantValue("1");
            AtomExpression atomExpression = new AtomExpression();
            atomExpression.setConstant(constant);
            AtomExpressionAlias atomExpressionAlias4 = new AtomExpressionAlias();
            atomExpressionAlias4.setAtomExpression(atomExpression);
            expression = new Expression();
            expression.setAtomExpressionAlias(atomExpressionAlias4);
            parameter2 = new Parameter();
            parameter2.setExpression(expression);
            sqlNode.getParameterSqlNodeList().addNode(parameter2);
        }
        if ("substr".equalsIgnoreCase(sqlNode.getFunctionName()) && sqlNode.getParameterSqlNodeList().getNodes().size() == 3 && (atomExpressionAlias = (parameter = sqlNode.getParameterSqlNodeList().getNodes().get(1)).getExpression().getAtomExpressionAlias()) != null && atomExpressionAlias.getAtomExpression().getConstant() != null && (constantValue = atomExpressionAlias.getAtomExpression().getConstant().getConstantValue()).equalsIgnoreCase("0")) {
            atomExpressionAlias.getAtomExpression().getConstant().setConstantValue("1");
        }
        if ("array_contains".equalsIgnoreCase(sqlNode.getFunctionName())) {
            sqlNode.setFunctionName("ANY");
            sqlNode.setOldFuncName("array_contains");
            if (sqlNode.getParameterSqlNodeList().getNodes().size() == 2) {
                sqlNode.setArrayContainsParameter(sqlNode.getParameterSqlNodeList().getNodes().get(1));
                sqlNode.getParameterSqlNodeList().getNodes().remove(1);
            }
        }
        return sqlNode;
    }

    private void convertRegexpFunc(Function sqlNode) {
        if ("regexp_replace".equalsIgnoreCase(sqlNode.getFunctionName()) && sqlNode.getParameterSqlNodeList().getNodes().size() == 3) {
            Parameter parameter = new Parameter();
            parameter.setTableAllColumns("'g'");
            sqlNode.getParameterSqlNodeList().addNode(parameter);
        }
        if ("REGEXP_SPLIT_TO_TABLE".equalsIgnoreCase(sqlNode.getFunctionName())) {
            this.dealWithDoubleQuoteInParam(sqlNode.getParameterSqlNodeList());
        }
        if ("regexp_extract".equalsIgnoreCase(sqlNode.getFunctionName())) {
            sqlNode.setFunctionName("REGEXP_MATCHES");
            List<Parameter> nodes = sqlNode.getParameterSqlNodeList().getNodes();
            if (nodes.size() == 3) {
                sqlNode.setRegexpExtractParameter(nodes.get(2));
                nodes.remove(2);
            }
        }
    }

    private Function convertTimeFunc(Function sqlNode, ConvertConfig config) {
        Parameter parameter;
        AtomExpressionAlias atomExpressionAlias;
        AtomExpression atomExpression;
        Constant constant;
        if (sqlNode.getFunctionName().equalsIgnoreCase("days_sub")) {
            sqlNode.setFunctionName("SUBDATE");
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("days_add")) {
            sqlNode.setFunctionName("ADDDATE");
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("years_sub") || sqlNode.getFunctionName().equalsIgnoreCase("months_sub")) {
            Pattern pattern;
            Matcher matcher;
            Expression expression = sqlNode.getParameterSqlNodeList().getNodes().get(1).getExpression();
            if (expression.getAtomExpressionAlias() != null && expression.getAtomExpressionAlias().getAtomExpression().getConstant() != null && (matcher = (pattern = Pattern.compile(this.numRegex)).matcher(expression.getAtomExpressionAlias().getAtomExpression().getConstant().getConstantValue())).find()) {
                if (sqlNode.getFunctionName().equalsIgnoreCase("months_sub")) {
                    sqlNode.getParameterSqlNodeList().getNodes().get(1).getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().setConstantValue(String.valueOf(Integer.valueOf(matcher.group(0)) * -1));
                } else {
                    sqlNode.getParameterSqlNodeList().getNodes().get(1).getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().setConstantValue(String.valueOf(Integer.valueOf(matcher.group(0)) * -12));
                }
            }
            sqlNode.setFunctionName("ADD_MONTHS");
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("unix_timestamp") && ConfigUtil.getConfigValue(config, "table.function.unix_timestamp", "false").equalsIgnoreCase("true")) {
            if (sqlNode.getParameterSqlNodeList().getNodes().size() == 2) {
                sqlNode.getParameterSqlNodeList().getNodes().remove(1);
            }
            constant = new Constant();
            constant.setConstantValue("'yyyy-mm-dd hh24:mi:ss'");
            atomExpression = new AtomExpression();
            atomExpression.setConstant(constant);
            atomExpressionAlias = new AtomExpressionAlias();
            atomExpressionAlias.setAtomExpression(atomExpression);
            Expression expression = new Expression();
            expression.setAtomExpressionAlias(atomExpressionAlias);
            Parameter parameter2 = new Parameter();
            parameter2.setExpression(expression);
            sqlNode.getParameterSqlNodeList().addNode(parameter2);
            SqlNodeList<Parameter> parameterSqlNodeList = new SqlNodeList<Parameter>();
            Parameter parameterToTime = new Parameter();
            Expression expressionToTime = new Expression();
            AtomExpressionAlias atomExpressionAliasToTime = new AtomExpressionAlias();
            AtomExpression atomExpressionToTime = new AtomExpression();
            Function function = new Function();
            function.setFunctionName("TO_TIMESTAMP");
            function.setParameterSqlNodeList(sqlNode.getParameterSqlNodeList());
            atomExpressionToTime.setFunction(function);
            atomExpressionAliasToTime.setAtomExpression(atomExpressionToTime);
            expressionToTime.setAtomExpressionAlias(atomExpressionAliasToTime);
            parameterToTime.setExpression(expressionToTime);
            parameterSqlNodeList.addNode(parameterToTime);
            sqlNode.setParameterSqlNodeList(parameterSqlNodeList);
            return null;
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("trunc")) {
            sqlNode.setFunctionName("DATE_TRUNC");
            Parameter parameter0 = sqlNode.getParameterSqlNodeList().getNodes().get(0);
            Parameter parameter1 = sqlNode.getParameterSqlNodeList().getNodes().get(1);
            if (parameter1.getExpression().getAtomExpressionAlias().getAtomExpression() != null && parameter1.getExpression().getAtomExpressionAlias().getAtomExpression().getConstant() != null) {
                if (parameter1.getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().getConstantValue().equals("'DD'")) {
                    parameter1.getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().setConstantValue("'D'");
                }
                if (parameter1.getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().getConstantValue().equals("'hh24'")) {
                    parameter1.getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().setConstantValue("'hour'");
                }
            }
            sqlNode.getParameterSqlNodeList().getNodes().set(0, parameter1);
            sqlNode.getParameterSqlNodeList().getNodes().set(1, parameter0);
        }
        if ((sqlNode.getFunctionName().equalsIgnoreCase("date_format") || sqlNode.getFunctionName().equalsIgnoreCase("from_unixtime")) && sqlNode.getParameterSqlNodeList().getNodes().size() > 1 && (parameter = sqlNode.getParameterSqlNodeList().getNodes().get(1)).getExpression() != null && parameter.getExpression().getAtomExpressionAlias() != null && parameter.getExpression().getAtomExpressionAlias().getAtomExpression().getConstant() != null) {
            String constantValue = parameter.getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().getConstantValue();
            if (QuoteUtils.removeAllQuote(constantValue).equalsIgnoreCase("yyyy-MM-dd")) {
                parameter.getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().setConstantValue("'%Y-%m-%d'");
            }
            if (QuoteUtils.removeAllQuote(constantValue).equalsIgnoreCase("yyyy-MM-dd HH:mm:ss")) {
                parameter.getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().setConstantValue("'%Y-%m-%d %H:%i:%s'");
            }
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("current_timestamp")) {
            constant = new Constant();
            constant.setConstantValue("0");
            atomExpression = new AtomExpression();
            atomExpression.setConstant(constant);
            atomExpressionAlias = new AtomExpressionAlias();
            atomExpressionAlias.setAtomExpression(atomExpression);
            Expression expression = new Expression();
            expression.setAtomExpressionAlias(atomExpressionAlias);
            Parameter parameter3 = new Parameter();
            parameter3.setExpression(expression);
            SqlNodeList<Parameter> sqlNodeList = new SqlNodeList<Parameter>();
            sqlNodeList.addNode(parameter3);
            sqlNode.setParameterSqlNodeList(sqlNodeList);
        }
        if (sqlNode.getFunctionName().equalsIgnoreCase("quarter")) {
            Function function = new Function();
            function.setFunctionName("TO_DATE");
            SqlNodeList<Parameter> parameterSqlNodeList = new SqlNodeList<Parameter>();
            parameterSqlNodeList.addNode(sqlNode.getParameterSqlNodeList().getNodes().get(0));
            Constant constant2 = new Constant();
            constant2.setConstantValue("'YYYY-MM-DD'");
            AtomExpression atomExpression2 = new AtomExpression();
            atomExpression2.setConstant(constant2);
            AtomExpressionAlias atomExpressionAlias2 = new AtomExpressionAlias();
            atomExpressionAlias2.setAtomExpression(atomExpression2);
            Expression expression = new Expression();
            expression.setAtomExpressionAlias(atomExpressionAlias2);
            Parameter parameter4 = new Parameter();
            parameter4.setExpression(expression);
            parameterSqlNodeList.addNode(parameter4);
            function.setParameterSqlNodeList(parameterSqlNodeList);
            SqlNodeList<Parameter> toDateParameterList = new SqlNodeList<Parameter>();
            AtomExpression toDateAtomExpression = new AtomExpression();
            toDateAtomExpression.setFunction(function);
            AtomExpressionAlias toDateAtomExpressionAlias = new AtomExpressionAlias();
            toDateAtomExpressionAlias.setAtomExpression(toDateAtomExpression);
            Expression toDateExpression = new Expression();
            toDateExpression.setAtomExpressionAlias(toDateAtomExpressionAlias);
            Parameter toDateParameter = new Parameter();
            toDateParameter.setExpression(toDateExpression);
            toDateParameterList.addNode(toDateParameter);
            sqlNode.setParameterSqlNodeList(toDateParameterList);
        }
        if ("sysdate".equalsIgnoreCase(sqlNode.getFunctionName())) {
            sqlNode.setFunctionName("CURRENT_DATE");
        }
        return null;
    }

    private void dealWithDoubleQuoteInParam(SqlNodeList<Parameter> parameterSqlNodeList) {
        for (int i = 0; i < parameterSqlNodeList.getNodes().size(); ++i) {
            if (parameterSqlNodeList.getNodes().get(i).getExpression() == null || parameterSqlNodeList.getNodes().get(i).getExpression().getAtomExpressionAlias() == null || parameterSqlNodeList.getNodes().get(i).getExpression().getAtomExpressionAlias().getAtomExpression().getConstant() == null || !parameterSqlNodeList.getNodes().get(i).getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().getConstantValue().trim().startsWith("\"") || !parameterSqlNodeList.getNodes().get(i).getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().getConstantValue().trim().endsWith("\"")) continue;
            parameterSqlNodeList.getNodes().get(i).getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().setConstantValue(QuoteUtils.addSingleQuote(QuoteUtils.removeDoubleQuote(parameterSqlNodeList.getNodes().get(i).getExpression().getAtomExpressionAlias().getAtomExpression().getConstant().getConstantValue())));
        }
    }
}

