/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.unparser;

import com.huawei.hwclouds.migration.hive.UnParser;
import com.huawei.hwclouds.migration.hive.UnParserAnnotation;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.nodes.LateralView;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=LateralView.class)
public class LateralViewUnParser
implements UnParser<LateralView> {
    @Override
    public void unParse(LateralView sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isLateralViewInColumn()) {
            if (sqlNode.getFunction().getFunctionName().equalsIgnoreCase("split")) {
                sqlNode.getFunction().setFunctionName("REGEXP_SPLIT_TO_TABLE");
            }
            sqlNode.getFunction().unParse(writer, context);
        } else {
            if (sqlNode.getOuterOrExplode() != null) {
                writer.append("LATERAL VIEW ").append(sqlNode.getOuterOrExplode()).writeSpace(1);
            }
            if (sqlNode.isExistParen()) {
                writer.append("(");
            }
            sqlNode.getFunction().unParse(writer, context);
            if (sqlNode.isExistParen()) {
                writer.append(") ");
            }
            writer.append(sqlNode.getTableAlias()).writeSpace(1);
            if (sqlNode.getIdList() != null) {
                writer.append("AS ");
                for (int i = 0; i < sqlNode.getIdList().size(); ++i) {
                    writer.append(sqlNode.getIdList().get(i));
                    if (i == sqlNode.getIdList().size() - 1) continue;
                    writer.append(", ");
                }
            }
        }
    }
}

