/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.unparser;

import com.huawei.hwclouds.migration.hive.UnParser;
import com.huawei.hwclouds.migration.hive.UnParserAnnotation;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.config.ConvertConfig;
import com.huawei.hwclouds.migration.hive.nodes.SelectClause;
import com.huawei.hwclouds.migration.hive.nodes.SelectItem;
import com.huawei.hwclouds.migration.hive.util.ConfigUtil;
import com.huawei.hwclouds.migration.hive.util.QuoteUtils;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.writer.SqlWriter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SelectClause.class)
public class SelectClauseUnParser
implements UnParser<SelectClause> {
    String hiveParser = "(.*)(\\+\\.\\+$)";

    @Override
    public void unParse(SelectClause sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("SELECT ");
        if (sqlNode.getQueryHint() != null) {
            writer.append(sqlNode.getQueryHint()).writeSpace(1);
        }
        if (sqlNode.getSelectItemSqlNodeList() != null) {
            ConvertConfig config;
            if (sqlNode.getDistinct() != null) {
                writer.append(sqlNode.getDistinct()).writeSpace(1);
            }
            if (ConfigUtil.getConfigValue(config = writer.getConfig("param.config.flag"), "table.column.addQuote", "false").equalsIgnoreCase("true")) {
                context.setValueColumn(true);
            }
            List<SelectItem> nodes = sqlNode.getSelectItemSqlNodeList().getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                this.dealWithSpecStation(nodes.get(i), sqlNode, i);
                nodes.get(i).unParse(writer, context);
                if (i == nodes.size() - 1) continue;
                writer.append(", ");
            }
            context.setValueColumn(false);
        }
    }

    private void dealWithSpecStation(SelectItem selectItem, SelectClause sqlNode, int index) {
        if (sqlNode.isContainInsertClause() && selectItem.getExpression() != null && selectItem.getExpression().getAtomExpressionAlias() != null && selectItem.getExpression().getAtomExpressionAlias().getAtomExpression().getTableOrColumn() != null) {
            String colValue = QuoteUtils.removeAllQuote(selectItem.getExpression().getAtomExpressionAlias().getAtomExpression().getTableOrColumn());
            Pattern pattern = Pattern.compile(this.hiveParser);
            Matcher matcher = pattern.matcher(colValue);
            if (matcher.find()) {
                SelectItem item = new SelectItem();
                item.setTableAllColumns("*");
                sqlNode.getSelectItemSqlNodeList().getNodes().set(index, item);
            }
        }
    }
}

