/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.hive.unparser;

import com.huawei.hwclouds.migration.hive.UnParser;
import com.huawei.hwclouds.migration.hive.UnParserAnnotation;
import com.huawei.hwclouds.migration.hive.UnParserContext;
import com.huawei.hwclouds.migration.hive.nodes.TableLocation;
import com.huawei.hwclouds.migration.hive.util.SqlDialect;
import com.huawei.hwclouds.migration.hive.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=TableLocation.class)
public class TableLocationUnParser
implements UnParser<TableLocation> {
    @Override
    public void unParse(TableLocation sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("SERVER obs_server OPTIONS (");
        if (sqlNode.getTableFileFormat() != null) {
            writer.append("FORMAT ");
            String inFmt = sqlNode.getTableFileFormat().getInFmt().toLowerCase(Locale.ROOT);
            if (inFmt.contains("org.apache.hadoop.hive.ql.io.parquet.mapredparquetinputformat")) {
                writer.append("'parquet',");
            } else if (inFmt.contains("org.apache.hadoop.hive.ql.io.orc.orcinputformat")) {
                writer.append("'orc',");
            } else if (inFmt.contains("org.apache.hadoop.mapred.textinputformat")) {
                writer.append("'text',");
            }
        }
        writer.append("ENCODING 'utf8',");
        String locn = sqlNode.getLocn().replace("obs:/", "");
        if (!locn.endsWith("/'")) {
            StringBuilder sb = new StringBuilder(locn);
            sb.setCharAt(locn.length() - 1, '/');
            sb.append("'");
            locn = sb.toString();
        }
        writer.append("foldername ").append(locn).append(")");
    }
}

