CREATE OR REPLACE FUNCTION mig_td_ext.mig_fn_get_datatype_short_name 
/* This function returns short name for the given data type name */
	    ( i_datatype	 IN		 VARCHAR ) 
RETURN VARCHAR
-- below line added as Gauss optimizer expects it for performance
IMMUTABLE 
AS
		l_short_datype	 		 CHAR(2);
BEGIN

    l_short_datype  := CASE UPPER(i_datatype)
							WHEN 'BYTEA'  							THEN 'BF'	/* BYTE and VARBYTE are converted as BYTEA */
							WHEN 'CHARACTER' 		 				THEN 'CF'
							WHEN 'CHARACTER VARYING'		 		THEN 'CV'
							WHEN 'TEXT'                             THEN 'LV'
							WHEN 'DOUBLE PRECISION'                 THEN 'DP'
							WHEN 'REAL'                             THEN 'RL'
							WHEN 'TIMESTAMP WITHOUT TIME ZONE' 		THEN 'DA'	/* TIMESTAMP and DATE will be treated as TIMESTAMP WITHOUT TIME ZONE in Gauss */
							WHEN 'FLOAT' 		 					THEN 'F '
							WHEN 'SMALLINT' 	 					THEN 'I2'	/* BYTEINT is converted as SMALLINT*/
							WHEN 'BIGINT' 		 					THEN 'I8'
							WHEN 'INTEGER' 		 					THEN 'I '
							WHEN 'TIME WITHOUT TIME ZONE' 		 	THEN 'AT'	/* TIME will be treated as TIME WITHOUT TIME ZONE in Gauss */
							WHEN 'TIMESTAMP WITHOUT TIME ZONE' 	 	THEN 'TS'	/* TIMESTAMP and DATE will be treated as TIMESTAMP WITHOUT TIME ZONE in Gauss */
							WHEN 'TIME WITH TIME ZONE'  	 		THEN 'TZ'
							WHEN 'TIMESTAMP WITH TIME ZONE' 	 	THEN 'SZ'
							WHEN 'INTERVAL' 				 		THEN 'YR'	/* INTERVAL "YEAR", "YEAR TO MONTH", "MONTH", "DAY", "DAY TO HOUR", "DAY TO MINUTE", "DAY TO SECOND", "HOUR", 
																				   "HOUR TO MINUTE", "HOUR TO SECOND", "MINUTE", "MINUTE TO SECOND" and "SECOND" will be INTERVAL in Gauss */
							WHEN 'BLOB' 						 	THEN 'BO'
							WHEN 'CLOB' 						 	THEN 'CO'
							WHEN 'DATERANGE' 				 	    THEN 'PD'	/* PERIOD(DATE) is converted as DATERANGE */
							WHEN 'TSRANGE' 				 	        THEN 'PT'	/* PERIOD(TIME) is converted as TSRANGE */
							WHEN 'TSTZRANGE' 	 	                THEN 'PZ'	/* PERIOD(TIME WITH TIME ZONE) is converted as TSTZRANGE */
							WHEN 'NUMERIC' 						 	THEN 'N ' 	/* Number, Numeric and Decimal will be treated as NUMERIC in Gauss */
							ELSE								 		 'UT'
					   END;

  RETURN l_short_datype;

END;
/

