CREATE OR REPLACE FUNCTION mig_td_ext.mig_fn_get_view_basetable
/* This function checks whether the given object is view. If it is a view, it finds 
   the base name if only one table is referred for the view; otherwise, it returns -1 */
	 ( i_schema_name    IN     TEXT
	 , i_object_name    IN     TEXT )
RETURN TEXT
AS
   basetbl_cnt     NUMBER(1);
   basetbl_name    TEXT;
BEGIN	
	SELECT COUNT(1) 
	  INTO basetbl_cnt
	  FROM information_schema.view_table_usage vtu
	 WHERE vtu.view_schema = LOWER(i_schema_name)
	   AND vtu.view_name   = LOWER(i_object_name)
	 LIMIT 2;
	
	IF basetbl_cnt = 0
	THEN
		RETURN NULL;
	ELSIF basetbl_cnt = 1
	THEN
		SELECT vtu.table_schema || '.' || vtu.table_name
		  INTO basetbl_name
		  FROM information_schema.view_table_usage vtu
		 WHERE vtu.view_schema = LOWER(i_schema_name)
		   AND vtu.view_name   = LOWER(i_object_name);
		
		RETURN basetbl_name;
	ELSE
	    RAISE EXCEPTION 'DML operation on View does not support if the view contains more than one base table.';
	END IF;

EXCEPTION
   WHEN OTHERS THEN
        RAISE;
END;
/ 
-- select mig_td_ext.mig_fn_get_view_basetable('public', 'vv1');---table v1
-- select mig_td_ext.mig_fn_get_view_basetable('public', 'v12');---table v1,v2